﻿using System;
using System.Collections.Specialized;
using MailBee;
using MailBee.ImapMail;
using DotNetOpenAuth.OAuth2;

class Sample
{
	static string GetAccessToken(string clientID, string clientSecret, string key)
	{
		UserAgentClient consumer;
		IAuthorizationState grantedAccess;

		StringDictionary parameters2 = new StringDictionary();
		parameters2.Add(OAuth2.RedirectUriKey, "https://login.live.com/oauth20_desktop.srf");

		AuthorizationServerDescription server = new AuthorizationServerDescription();
		server.AuthorizationEndpoint = new Uri("https://login.live.com/oauth20_authorize.srf");
		server.TokenEndpoint = new Uri("https://login.live.com/oauth20_token.srf");
		server.ProtocolVersion = ProtocolVersion.V20;

		consumer = new UserAgentClient(server, clientID, clientSecret);

		consumer.ClientCredentialApplicator = ClientCredentialApplicator.PostParameter(clientSecret);

		IAuthorizationState authorizationState = new AuthorizationState(null);

		if (parameters2.ContainsKey(OAuth2.RedirectUriKey))
		{
			authorizationState.Callback = new Uri(parameters2[OAuth2.RedirectUriKey]);
		}

		try
		{
			grantedAccess = consumer.ProcessUserAuthorization(
				new Uri("http://example.com/?code=" + key), authorizationState);
		}
		catch (DotNetOpenAuth.Messaging.ProtocolException e)
		{
			Console.WriteLine(e.Message);
			return null;
		}

		return grantedAccess.AccessToken;
	}

	static void Main(string[] args)
	{
		// You get these at https://account.live.com/developers/applications/create
		string clientID = "000000004C12XXXX";
		string clientSecret = "VYXA3t02FHdjq-5JrQt5j2RzFoe5XXXX";

		// Can be hotmail.com, outlook.com, live.com, etc. All MS services will work.
		// See advanced sample on how to autodetect the e-mail address.
		string userEmail = "XXXX@hotmail.com";

		OAuth2 myOAuth2 = new OAuth2(clientID, clientSecret);

		StringDictionary parameters1 = new StringDictionary();
		parameters1.Add(OAuth2.Scope, "wl.imap");
		parameters1.Add(OAuth2.RedirectUriKey, "https://login.live.com/oauth20_desktop.srf");
		parameters1.Add(OAuth2.ResponseTypeKey, "code");

		System.Diagnostics.Process.Start(
			myOAuth2.AuthorizeToken("https://login.live.com/oauth20_authorize.srf", parameters1));

		Console.Write("Please enter the Authorization code: ");
		string key = Console.ReadLine().Trim();

		string accessToken = GetAccessToken(clientID, clientSecret, key);
		if (accessToken == null)
		{
			return;
		}

		string imapXOAuthKey = myOAuth2.GetXOAuthKey(userEmail, accessToken);

		Imap imp = new Imap();

		// Logging is not necessary but useful for debugging.
		imp.Log.Filename = "C:\\Temp\\log.txt";
		imp.Log.HidePasswords = false;
		imp.Log.Enabled = true;
		imp.Log.Clear();

		imp.Connect("imap-mail.outlook.com", 993);
		imp.Login(null, imapXOAuthKey, AuthenticationMethods.SaslOAuth2, AuthenticationOptions.None, null);
		imp.SelectFolder("INBOX");

		Console.WriteLine(imp.MessageCount.ToString() + " message(s) in INBOX");

		imp.Disconnect();
	}
}