<?php
/**
 * This code is licensed under AGPLv3 license or Afterlogic Software License
 * if commercial version of the product was purchased.
 * For full statements of the licenses see LICENSE-AFTERLOGIC and LICENSE-AGPL3 files.
 */

namespace MailSo;

/**
 * @license https://www.gnu.org/licenses/agpl-3.0.html AGPL-3.0
 * @license https://afterlogic.com/products/common-licensing Afterlogic Software License
 * @copyright Copyright (c) 2019, Afterlogic Corp.
 *
 * @category MailSo
 */
class Config
{
    /**
     * @var bool
     */
    public static $ICONV = true;

    /**
     * @var bool
     */
    public static $MBSTRING = true;

    /**
     * @var bool
     */
    public static $FixIconvByMbstring = true;

    /**
     * @var int
     */
    public static $MessageListFastSimpleSearch = true;

    /**
     * @var int
     */
    public static $MessageListCountLimitTrigger = 0;

    /**
     * @var int
     */
    public static $MessageListDateFilter = 0;

    /**
     * @var int
     */
    public static $LargeThreadLimit = 100;

    /**
     * @var bool
     */
    public static $LogSimpleLiterals = false;

    /**
     * @var bool
     */
    public static $PreferStartTlsIfAutoDetect = true;

    /**
     * @var \MailSo\Log\Logger|null
     */
    public static $SystemLogger = null;
}
