(self["webpackChunkaurora_webmail_pro"] = self["webpackChunkaurora_webmail_pro"] || []).push([[13],{

/***/ "2KI4":
/*!********************************************!*\
  !*** ./modules/FilesWebclient/js/enums.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var _ = __webpack_require__(/*! underscore */ "C3HO"),
  Enums = {};

/**
 * @enum {number}
 */
Enums.FileStorageType = {
  'Personal': 'personal',
  'Corporate': 'corporate',
  'Shared': 'shared',
  'GoogleDrive': 'google',
  'Dropbox': 'dropbox',
  'Encrypted': 'encrypted',
  'Trash': 'trash',
  'Favorites': 'favorites'
};

/**
 * @enum {number}
 */
Enums.FileStorageLinkType = {
  'Unknown': 0,
  'GoogleDrive': 1,
  'Dropbox': 2,
  'YouTube': 3,
  'Vimeo': 4,
  'SoundCloud': 5
};

/**
 * @enum {number}
 */
Enums.SharedFileAccess = {
  'NoAccess': 0,
  'Write': 1,
  'Read': 2,
  'Reshare': 3
};

/**
 * @enum {number}
 */
Enums.FilesSortField = {
  'Filename': 0,
  'Size': 1,
  'Modified': 2
};
if (typeof window.Enums === 'undefined') {
  window.Enums = {};
}
_.extendOwn(window.Enums, Enums);

/***/ }),

/***/ "FTUa":
/*!**********************************************!*\
  !*** ./modules/FilesWebclient/js/manager.js ***!
  \**********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


module.exports = function (oAppData) {
  __webpack_require__(/*! modules/FilesWebclient/js/enums.js */ "2KI4");
  var $ = __webpack_require__(/*! jquery */ "M4cL"),
    App = __webpack_require__(/*! modules/CoreWebclient/js/App.js */ "yU9o"),
    ModulesManager = __webpack_require__(/*! modules/CoreWebclient/js/ModulesManager.js */ "5D2l"),
    TextUtils = __webpack_require__(/*! modules/CoreWebclient/js/utils/Text.js */ "LKDt"),
    Settings = __webpack_require__(/*! modules/FilesWebclient/js/Settings.js */ "aSuo");
  var HeaderItemView = null,
    aToolbarButtons = [],
    filesViewInstance = null;
  var getFilesViewInstance = function getFilesViewInstance() {
    if (!filesViewInstance) {
      var CFilesView = __webpack_require__(/*! modules/FilesWebclient/js/views/CFilesView.js */ "v0iR");
      filesViewInstance = new CFilesView();
      if (!App.isPublic()) {
        filesViewInstance.registerToolbarButtons(aToolbarButtons);
        aToolbarButtons = [];
      }
    }
    return filesViewInstance;
  };
  Settings.init(oAppData);
  if (!ModulesManager.isModuleAvailable(Settings.ServerModuleName) || !App.isPublic() && Settings.Storages.length === 0) {
    return null;
  }
  if (App.isPublic()) {
    return {
      getScreens: function getScreens() {
        var oScreens = {};
        oScreens[Settings.HashModuleName] = getFilesViewInstance;
        return oScreens;
      }
    };
  } else if (App.isUserNormalOrTenant()) {
    if (App.isNewTab()) {
      return {
        getSelectFilesPopup: function getSelectFilesPopup() {
          return __webpack_require__(/*! modules/FilesWebclient/js/popups/SelectFilesPopup.js */ "jkTn");
        }
      };
    } else {
      return {
        start: function start(ModulesManager) {
          if (Settings.ShowCommonSettings || Settings.ShowFilesApps) {
            ModulesManager.run('SettingsWebclient', 'registerSettingsTab', [function () {
              return __webpack_require__(/*! modules/FilesWebclient/js/views/FilesSettingsFormView.js */ "lfpz");
            }, Settings.HashModuleName, TextUtils.i18n('FILESWEBCLIENT/LABEL_SETTINGS_TAB')]);
          }
          App.broadcastEvent('RegisterNewItemElement', {
            'title': TextUtils.i18n('FILESWEBCLIENT/ACTION_UPLOAD_FILES'),
            'handler': function handler() {
              // check if we are on contacts screen or not
              if (!window.location.hash.startsWith('#' + Settings.HashModuleName)) {
                window.location.hash = Settings.HashModuleName;
              }
              var filesViewInstance = getFilesViewInstance();
              function clickUploaderButton() {
                var input = filesViewInstance.uploaderButton().find('input')[0];
                if (input) {
                  input.click();
                  // in case of Upload Button it's needed to emulate click on the button to close the menu
                  setTimeout(function () {
                    $('.tabsbar .new_button_panel')[0].click();
                  }, 0);
                }
              }
              if (filesViewInstance.isCreateAllowed()) {
                if (filesViewInstance.uploaderButton() && filesViewInstance.uploaderButton().find('input').length) {
                  clickUploaderButton();
                } else {
                  var uploaderButtonSubscription = filesViewInstance.uploaderButton.subscribe(function () {
                    // Using setTimeout to ensure the DOM is updated before triggering the click
                    setTimeout(function () {
                      clickUploaderButton();
                      uploaderButtonSubscription.dispose();
                    }, 0);
                  });
                }
              }
            },
            'className': 'item_files',
            'order': 1,
            'column': 2
          });
          App.broadcastEvent('RegisterNewItemElement', {
            'title': TextUtils.i18n('FILESWEBCLIENT/ACTION_NEW_FOLDER'),
            'handler': function handler() {
              // check if we are on contacts screen or not
              if (!window.location.hash.startsWith('#' + Settings.HashModuleName)) {
                window.location.hash = Settings.HashModuleName;
              }
              var filesViewInstance = getFilesViewInstance();
              var command = filesViewInstance.createFolderCommand;
              if (command.canExecute()) {
                command();
              }
            },
            'className': 'item_folder',
            'order': 5,
            'column': 2
          });
        },
        getScreens: function getScreens() {
          var oScreens = {};
          oScreens[Settings.HashModuleName] = getFilesViewInstance;
          return oScreens;
        },
        getHeaderItem: function getHeaderItem() {
          if (HeaderItemView === null) {
            var CHeaderItemView = __webpack_require__(/*! modules/CoreWebclient/js/views/CHeaderItemView.js */ "cR1d"),
              sTabTitle = Settings.CustomTabTitle !== '' ? Settings.CustomTabTitle : TextUtils.i18n('FILESWEBCLIENT/ACTION_SHOW_FILES');
            HeaderItemView = new CHeaderItemView(sTabTitle);
          }
          return {
            item: HeaderItemView,
            name: Settings.HashModuleName
          };
        },
        getSelectFilesPopup: function getSelectFilesPopup() {
          return __webpack_require__(/*! modules/FilesWebclient/js/popups/SelectFilesPopup.js */ "jkTn");
        },
        getMobileSyncSettingsView: function getMobileSyncSettingsView() {
          return __webpack_require__(/*! modules/FilesWebclient/js/views/MobileSyncSettingsView.js */ "vV+s");
        },
        getFileConstructor: function getFileConstructor(oFile) {
          return __webpack_require__(/*! modules/FilesWebclient/js/models/CFileModel.js */ "8ri2");
        },
        addFileToCurrentFolder: function addFileToCurrentFolder(oFile) {
          if (filesViewInstance) {
            filesViewInstance.addFileToCurrentFolder(oFile);
          }
        },
        refresh: function refresh() {
          if (filesViewInstance) {
            filesViewInstance.refresh();
          }
        },
        registerToolbarButtons: function registerToolbarButtons(oToolbarButtons) {
          if (filesViewInstance) {
            filesViewInstance.registerToolbarButtons([oToolbarButtons]);
          } else {
            aToolbarButtons.push(oToolbarButtons);
          }
        }
      };
    }
  }
  return null;
};

/***/ }),

/***/ "cR1d":
/*!***********************************************************!*\
  !*** ./modules/CoreWebclient/js/views/CHeaderItemView.js ***!
  \***********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var ko = __webpack_require__(/*! knockout */ "p09A"),
  Routing = __webpack_require__(/*! modules/CoreWebclient/js/Routing.js */ "ioSH");
function CHeaderItemView(sLinkText) {
  this.sName = '';
  this.visible = ko.observable(true);
  this.baseHash = ko.observable('');
  this.hash = ko.observable('');
  this.linkText = ko.observable(sLinkText);
  this.isCurrent = ko.observable(false);
  this.recivedAnim = ko.observable(false).extend({
    'autoResetToFalse': 500
  });
  this.unseenCount = ko.observable(0);
  this.allowChangeTitle = ko.observable(false); // allows to change favicon and browser title when browser is inactive
  this.inactiveTitle = ko.observable('');
  this.excludedHashes = ko.observableArray([]);
}
CHeaderItemView.prototype.ViewTemplate = 'CoreWebclient_HeaderItemView';
CHeaderItemView.prototype.setName = function (sName) {
  this.sName = sName.toLowerCase();
  if (this.baseHash() === '') {
    this.hash(Routing.buildHashFromArray([sName.toLowerCase()]));
    this.baseHash(this.hash());
  } else {
    this.hash(this.baseHash());
  }
};
module.exports = CHeaderItemView;

/***/ }),

/***/ "jkTn":
/*!**************************************************************!*\
  !*** ./modules/FilesWebclient/js/popups/SelectFilesPopup.js ***!
  \**************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var _ = __webpack_require__(/*! underscore */ "C3HO"),
  CAbstractPopup = __webpack_require__(/*! modules/CoreWebclient/js/popups/CAbstractPopup.js */ "69av"),
  CFilesView = __webpack_require__(/*! modules/FilesWebclient/js/views/CFilesView.js */ "v0iR");

/**
 * @constructor
 */
function CSelectFilesPopup() {
  CAbstractPopup.call(this);
  this.callbackHandler = function () {};
  this.filesView = new CFilesView(true);
  this.filesView.onSelectClickPopupBound = _.bind(this.selectFiles, this);
}
_.extendOwn(CSelectFilesPopup.prototype, CAbstractPopup.prototype);
CSelectFilesPopup.prototype.PopupTemplate = 'FilesWebclient_SelectFilesPopup';

/**
 * @param {Function} callbackHandler
 */
CSelectFilesPopup.prototype.onOpen = function (callbackHandler) {
  this.callbackHandler = _.isFunction(callbackHandler) ? callbackHandler : function () {};
  this.filesView.onShow();
};
CSelectFilesPopup.prototype.onBind = function () {
  this.filesView.onBind(this.$popupDom);
};
CSelectFilesPopup.prototype.selectFiles = function () {
  var selectedItems = this.filesView.selector.listCheckedAndSelected(),
    selectedFiles = selectedItems.filter(function (item) {
      return item.IS_FILE;
    });
  this.callbackHandler(selectedFiles);
  this.closePopup();
};
module.exports = new CSelectFilesPopup();

/***/ }),

/***/ "lfpz":
/*!******************************************************************!*\
  !*** ./modules/FilesWebclient/js/views/FilesSettingsFormView.js ***!
  \******************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var _ = __webpack_require__(/*! underscore */ "C3HO"),
  ModulesManager = __webpack_require__(/*! modules/CoreWebclient/js/ModulesManager.js */ "5D2l"),
  UrlUtils = __webpack_require__(/*! modules/CoreWebclient/js/utils/Url.js */ "3cxN"),
  CAbstractSettingsFormView = ModulesManager.run('SettingsWebclient', 'getAbstractSettingsFormViewClass'),
  Settings = __webpack_require__(/*! modules/FilesWebclient/js/Settings.js */ "aSuo");

/**
 * @constructor
 */
function CFilesSettingsFormView() {
  CAbstractSettingsFormView.call(this, 'FilesWebclient');
  this.bShowFilesApps = Settings.ShowFilesApps;
  this.sAppPath = UrlUtils.getAppPath();
}
_.extendOwn(CFilesSettingsFormView.prototype, CAbstractSettingsFormView.prototype);
CFilesSettingsFormView.prototype.ViewTemplate = 'FilesWebclient_FilesSettingsFormView';
module.exports = new CFilesSettingsFormView();

/***/ }),

/***/ "vV+s":
/*!*******************************************************************!*\
  !*** ./modules/FilesWebclient/js/views/MobileSyncSettingsView.js ***!
  \*******************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var ko = __webpack_require__(/*! knockout */ "p09A"),
  App = __webpack_require__(/*! modules/CoreWebclient/js/App.js */ "yU9o"),
  UserSettings = __webpack_require__(/*! modules/CoreWebclient/js/Settings.js */ "KIwC");

/**
 * @constructor
 */
function CMobileSyncSettingsView() {
  this.davServer = ko.observable('');
  this.credentialsHintText = App.mobileCredentialsHintText;
  this.bDemo = UserSettings.IsDemo;
}
CMobileSyncSettingsView.prototype.ViewTemplate = 'FilesWebclient_MobileSyncSettingsView';

/**
 * @param {Object} oDav
 */
CMobileSyncSettingsView.prototype.populate = function (oDav) {
  this.davServer(oDav.Server);
};
module.exports = new CMobileSyncSettingsView();

/***/ })

}]);