"use strict";
(self["webpackChunkaurora_webmail_pro"] = self["webpackChunkaurora_webmail_pro"] || []).push([[4],{

/***/ "SfAM":
/*!******************************************************************!*\
  !*** ./modules/ContactsMobileWebclient/js/views/ContactsView.js ***!
  \******************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

/* provided dependency */ var $ = __webpack_require__(/*! jquery */ "M4cL");


var _ = __webpack_require__(/*! underscore */ "C3HO"),
  ko = __webpack_require__(/*! knockout */ "p09A"),
  f7 = __webpack_require__(/*! framework7 */ "Fiyv"),
  // needs to be initialized

  Types = __webpack_require__(/*! modules/CoreWebclient/js/utils/Types.js */ "ERH9"),
  App = __webpack_require__(/*! modules/CoreWebclient/js/App.js */ "yU9o"),
  CContactsDesktopView = __webpack_require__(/*! modules/ContactsWebclient/js/views/CContactsView.js */ "/u0n"),
  CGroupModel = __webpack_require__(/*! modules/ContactsWebclient/js/models/CGroupModel.js */ "rIhA"),
  Enums = window.Enums;
if (!window.f7App) {
  window.f7App = new Framework7({
    fastClicks: false,
    tapHoldPreventClicks: false,
    pushState: false
  });
}

/**
 * @constructor
 */
function CContactsView() {
  CContactsDesktopView.call(this);
  this.oPageSwitcher.ViewTemplate = 'CoreMobileWebclient_PageSwitcherView';
  this.visibleDragNDropToGroupText = ko.observable(false);
  this.selectedPanel = ko.observable(Enums.MobilePanel.Items);
  this.selectedItem.subscribe(function (oItem) {
    var bViewGroup = oItem && oItem instanceof CGroupModel && !oItem.isNew();
    if (oItem && !bViewGroup) {
      this.gotoViewPane();
    } else {
      this.gotoContactList();
    }
  }, this);
  App.broadcastEvent('ContactsMobileWebclient::ConstructView::after', {
    'Name': this.ViewConstructorName,
    'View': this
  });
  this.appsDom = null;
  this.showApps = ko.observable(false);
  this.init();
}
_.extendOwn(CContactsView.prototype, CContactsDesktopView.prototype);
CContactsView.prototype.ViewTemplate = 'ContactsMobileWebclient_ContactsScreenView';
CContactsView.prototype.ViewConstructorName = 'CContactsView';
CContactsView.prototype.init = function () {
  this.selectedPanel.subscribe(function (value) {
    var bOpen = value === Enums.MobilePanel.Groups;
    $('body').toggleClass('with-panel-left-reveal', bOpen).toggleClass('panel-closing', !bOpen);
  });
  var self = this;
  this.appsDom = $('#apps-list');
  this.appsDom.on('click', function () {
    self.showApps(false);
  });
  this.showApps.subscribe(function (value) {
    $('body').toggleClass('with-panel-right-cover', value);
  }, this);
};
CContactsView.prototype.togleGroupList = function (oData, oEvent, bValue) {
  var bValue = bValue || this.selectedPanel() !== Enums.MobilePanel.Groups,
    newPanel = bValue ? Enums.MobilePanel.Groups : Enums.MobilePanel.Items;
  this.changeSelectedPanel(newPanel);
};

/**
 * Ajax.send - 'CreateGroup', 'UpdateGroup'
 * cancel group edit
 */
CContactsView.prototype.gotoGroupList = function () {
  this.changeSelectedPanel(Enums.MobilePanel.Groups);
};

/**
 * onRoute if (this.selectedItem() instanceof CContactModel)
 * @returns {Boolean}
 */
CContactsView.prototype.gotoContactList = function () {
  this.changeSelectedPanel(Enums.MobilePanel.Items);
  return true;
};

/**
 * onRoute if oParams.Action 'create-contact', 'create-group', 'import'
 */
CContactsView.prototype.gotoViewPane = function () {
  this.changeSelectedPanel(Enums.MobilePanel.View);
};
CContactsView.prototype.backToContactList = function () {
  this.changeRouting();
};

/**
 * @param {number} iPanel
 */
CContactsView.prototype.changeSelectedPanel = function (iPanel) {
  this.selectedPanel(iPanel);
};
CContactsView.prototype.composeMessage = function () {
  var aList = this.selector.listCheckedOrSelected(),
    aEmails = Types.isNonEmptyArray(aList) ? _.compact(_.map(aList, function (oItem) {
      return oItem.Email() !== '' ? oItem.getFullEmail() : '';
    })) : [],
    sEmails = aEmails.join(', ');
  if (sEmails !== '') {
    this.composeMessageToAddresses(sEmails);
  }
};
module.exports = new CContactsView();

/***/ }),

/***/ "XSzC":
/*!*******************************************************!*\
  !*** ./modules/ContactsMobileWebclient/js/manager.js ***!
  \*******************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {



module.exports = function (oAppData) {
  var Types = __webpack_require__(/*! modules/CoreWebclient/js/utils/Types.js */ "ERH9"),
    App = __webpack_require__(/*! modules/CoreWebclient/js/App.js */ "yU9o"),
    ModulesManager = __webpack_require__(/*! modules/CoreWebclient/js/ModulesManager.js */ "5D2l"),
    ContactsSettings = null;
  if (!ModulesManager.isModuleAvailable('CoreMobileWebclient')) {
    return null;
  }
  if (App.isUserNormalOrTenant()) {
    if (App.isMobile()) {
      var setContactsSettings = function setContactsSettings() {
        if (ContactsSettings === null) {
          ContactsSettings = ModulesManager.run('ContactsWebclient', 'getSettings');
        }
      };
      return {
        getScreens: function getScreens() {
          setContactsSettings();
          var oScreens = {};
          if (ContactsSettings && Types.isNonEmptyString(ContactsSettings.HashModuleName)) {
            oScreens[ContactsSettings.HashModuleName] = function () {
              return __webpack_require__(/*! modules/ContactsMobileWebclient/js/views/ContactsView.js */ "SfAM");
            };
          }
          return oScreens;
        },
        getHeaderItem: function getHeaderItem() {
          setContactsSettings();
          var HeaderItemView = ModulesManager.run('ContactsWebclient', 'getHeaderItemView');
          if (ContactsSettings && Types.isNonEmptyString(ContactsSettings.HashModuleName) && HeaderItemView) {
            return {
              item: HeaderItemView,
              name: ContactsSettings.HashModuleName
            };
          }
          return null;
        }
      };
    }
  }
  return null;
};

/***/ })

}]);