<?php
/*
 * login_with_meetup.php
 *
 * @(#) $Id: login_with_meetup.php,v 1.1 2014/12/23 03:51:59 mlemos Exp $
 *
 */

/*
 *  Get the http.php file from http://www.phpclasses.org/httpclient
 */
require('http.php');
require('oauth_client.php');

$client = new oauth_client_class();
$client->debug = false;
$client->debug_http = true;
$client->server = 'Meetup';
$client->redirect_uri = 'http://'.$_SERVER['HTTP_HOST'].
    dirname(strtok($_SERVER['REQUEST_URI'], '?')).'/login_with_meetup.php';

$client->client_id = '';
$application_line = __LINE__;
$client->client_secret = '';

if (strlen($client->client_id) == 0
|| strlen($client->client_secret) == 0) {
    die('Please go to your Meetup OAuth Consumers page '.
        'https://secure.meetup.com/meetup_api/oauth_consumers/ , '.
        'create a consumer, and in the line '.$application_line.
        ' set the client_id to Key and client_secret with Secret. '.
        'The Callback URL must be '.$client->redirect_uri.
        ' Make sure the Website URL is not in a private network '.
        'and is accessible to the Meetup site.');
}

if (($success = $client->Initialize())) {
    if (($success = $client->Process())) {
        if (strlen($client->access_token)) {
            $success = $client->CallAPI(
                'https://api.meetup.com/2/member/self',
                'GET',
                array(),
                array('FailOnAccessError'=>true),
                $user
            );
        }
    }
    $success = $client->Finalize($success);
}
if ($client->exit) {
    exit;
}
if ($success) {
    ?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
<title>Meetup OAuth client results</title>
</head>
<body>
<?php
            echo '<h1>', HtmlSpecialChars($user->name),
    ' you have logged in successfully with Meetup!</h1>';
    echo '<pre>', HtmlSpecialChars(print_r($user, 1)), '</pre>';
    ?>
</body>
</html>
<?php
} else {
    ?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
<title>OAuth client error</title>
</head>
<body>
<h1>OAuth client error</h1>
<p>Error: <?php echo HtmlSpecialChars($client->error); ?></p>
</body>
</html>
<?php
}

?>