"use strict";
(self["webpackChunkafterlogic_aurora_platform"] = self["webpackChunkafterlogic_aurora_platform"] || []).push([[36],{

/***/ "6A93":
/*!*************************************************************************!*\
  !*** ./modules/CoreParanoidEncryptionWebclientPlugin/js/JscryptoKey.js ***!
  \*************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {



function _regenerator() { /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/babel/babel/blob/main/packages/babel-helpers/LICENSE */ var e, t, r = "function" == typeof Symbol ? Symbol : {}, n = r.iterator || "@@iterator", o = r.toStringTag || "@@toStringTag"; function i(r, n, o, i) { var c = n && n.prototype instanceof Generator ? n : Generator, u = Object.create(c.prototype); return _regeneratorDefine2(u, "_invoke", function (r, n, o) { var i, c, u, f = 0, p = o || [], y = !1, G = { p: 0, n: 0, v: e, a: d, f: d.bind(e, 4), d: function d(t, r) { return i = t, c = 0, u = e, G.n = r, a; } }; function d(r, n) { for (c = r, u = n, t = 0; !y && f && !o && t < p.length; t++) { var o, i = p[t], d = G.p, l = i[2]; r > 3 ? (o = l === n) && (u = i[(c = i[4]) ? 5 : (c = 3, 3)], i[4] = i[5] = e) : i[0] <= d && ((o = r < 2 && d < i[1]) ? (c = 0, G.v = n, G.n = i[1]) : d < l && (o = r < 3 || i[0] > n || n > l) && (i[4] = r, i[5] = n, G.n = l, c = 0)); } if (o || r > 1) return a; throw y = !0, n; } return function (o, p, l) { if (f > 1) throw TypeError("Generator is already running"); for (y && 1 === p && d(p, l), c = p, u = l; (t = c < 2 ? e : u) || !y;) { i || (c ? c < 3 ? (c > 1 && (G.n = -1), d(c, u)) : G.n = u : G.v = u); try { if (f = 2, i) { if (c || (o = "next"), t = i[o]) { if (!(t = t.call(i, u))) throw TypeError("iterator result is not an object"); if (!t.done) return t; u = t.value, c < 2 && (c = 0); } else 1 === c && (t = i["return"]) && t.call(i), c < 2 && (u = TypeError("The iterator does not provide a '" + o + "' method"), c = 1); i = e; } else if ((t = (y = G.n < 0) ? u : r.call(n, G)) !== a) break; } catch (t) { i = e, c = 1, u = t; } finally { f = 1; } } return { value: t, done: y }; }; }(r, o, i), !0), u; } var a = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} t = Object.getPrototypeOf; var c = [][n] ? t(t([][n]())) : (_regeneratorDefine2(t = {}, n, function () { return this; }), t), u = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(c); function f(e) { return Object.setPrototypeOf ? Object.setPrototypeOf(e, GeneratorFunctionPrototype) : (e.__proto__ = GeneratorFunctionPrototype, _regeneratorDefine2(e, o, "GeneratorFunction")), e.prototype = Object.create(u), e; } return GeneratorFunction.prototype = GeneratorFunctionPrototype, _regeneratorDefine2(u, "constructor", GeneratorFunctionPrototype), _regeneratorDefine2(GeneratorFunctionPrototype, "constructor", GeneratorFunction), GeneratorFunction.displayName = "GeneratorFunction", _regeneratorDefine2(GeneratorFunctionPrototype, o, "GeneratorFunction"), _regeneratorDefine2(u), _regeneratorDefine2(u, o, "Generator"), _regeneratorDefine2(u, n, function () { return this; }), _regeneratorDefine2(u, "toString", function () { return "[object Generator]"; }), (_regenerator = function _regenerator() { return { w: i, m: f }; })(); }
function _regeneratorDefine2(e, r, n, t) { var i = Object.defineProperty; try { i({}, "", {}); } catch (e) { i = 0; } _regeneratorDefine2 = function _regeneratorDefine(e, r, n, t) { function o(r, n) { _regeneratorDefine2(e, r, function (e) { return this._invoke(r, n, e); }); } r ? i ? i(e, r, { value: n, enumerable: !t, configurable: !t, writable: !t }) : e[r] = n : (o("next", 0), o("throw", 1), o("return", 2)); }, _regeneratorDefine2(e, r, n, t); }
function asyncGeneratorStep(n, t, e, r, o, a, c) { try { var i = n[a](c), u = i.value; } catch (n) { return void e(n); } i.done ? t(u) : Promise.resolve(u).then(r, o); }
function _asyncToGenerator(n) { return function () { var t = this, e = arguments; return new Promise(function (r, o) { var a = n.apply(t, e); function _next(n) { asyncGeneratorStep(a, r, o, _next, _throw, "next", n); } function _throw(n) { asyncGeneratorStep(a, r, o, _next, _throw, "throw", n); } _next(void 0); }); }; }
var _ = __webpack_require__(/*! underscore */ "C3HO"),
  ko = __webpack_require__(/*! knockout */ "p09A"),
  TextUtils = __webpack_require__(/*! modules/CoreWebclient/js/utils/Text.js */ "LKDt"),
  Storage = __webpack_require__(/*! modules/CoreWebclient/js/Storage.js */ "oJUS"),
  Screens = __webpack_require__(/*! modules/CoreWebclient/js/Screens.js */ "D2Gh"),
  UserSettings = __webpack_require__(/*! modules/CoreWebclient/js/Settings.js */ "KIwC"),
  HexUtils = __webpack_require__(/*! modules/CoreParanoidEncryptionWebclientPlugin/js/utils/Hex.js */ "v25v"),
  Popups = __webpack_require__(/*! modules/CoreWebclient/js/Popups.js */ "PMEU"),
  DecryptKeyPasswordPopup = __webpack_require__(/*! modules/CoreParanoidEncryptionWebclientPlugin/js/popups/DecryptKeyPasswordPopup.js */ "wOV2"),
  EncryptKeyPasswordPopup = __webpack_require__(/*! modules/CoreParanoidEncryptionWebclientPlugin/js/popups/EncryptKeyPasswordPopup.js */ "oMpj");

/**
 * @constructor
 */
function CJscryptoKey() {
  this.key = ko.observable();
  this.keyName = ko.observable();
}
CJscryptoKey.prototype.key = null;

/**
 * Asynchronously read key from storage, decrypt and generate key-object
 *
 * @param {Function} fOnGenerateKeyCallback - starts after the key is successfully generated
 * @param {Function} fOnErrorCallback - starts if error occurred during key generation process
 * @param {string} sPassword - encrypt key with given password, "password dialog" wouldn't show
 * @param {boolean} bForcedKeyLoading - forced key loading and decryption
 */
CJscryptoKey.prototype.getKey = function (fOnGenerateKeyCallback, fOnErrorCallback, sPassword, bForcedKeyLoading) {
  var sEncryptedKeyData = this.loadKeyFromStorage(),
    oPromise = new Promise(function (resolve, reject) {
      var fDecryptKeyCallback = _.bind(function (sPassword) {
        //Decrypt key with user password
        this.decryptKeyData(sEncryptedKeyData, sPassword).then(_.bind(function (aKeyData) {
          //generate key object from encrypted data
          this.generateKeyFromArray(aKeyData).then(function (oKey) {
            //return key object
            resolve(oKey);
          })["catch"](function (e) {
            reject(new Error(TextUtils.i18n('COREPARANOIDENCRYPTIONWEBCLIENTPLUGIN/ERROR_LOAD_KEY')));
          });
        }, this))["catch"](function (e) {
          reject(new Error(TextUtils.i18n('COREPARANOIDENCRYPTIONWEBCLIENTPLUGIN/ERROR_LOAD_KEY')));
        });
      }, this);
      if (!sEncryptedKeyData) {
        reject(new Error(TextUtils.i18n('COREPARANOIDENCRYPTIONWEBCLIENTPLUGIN/INFO_EMPTY_JSCRYPTO_KEY')));
      } else {
        if (!this.key() || bForcedKeyLoading) {
          //if key not available or loading is forced - encrypt key data
          if (!sPassword) {
            //if password is unknown - request password
            Popups.showPopup(DecryptKeyPasswordPopup, [fDecryptKeyCallback, function () {
              if (_.isFunction(fOnErrorCallback)) {
                fOnErrorCallback();
              }
            }]);
          } else {
            //if password is known - decrypt key with this password
            fDecryptKeyCallback(sPassword);
          }
        } else {
          //if key already available - return key
          resolve(this.key());
        }
      }
    }.bind(this));
  this.loadKeyNameFromStorage();
  oPromise.then(_.bind(function (oKey) {
    this.onKeyGenerateSuccess(oKey);
    if (_.isFunction(fOnGenerateKeyCallback)) {
      fOnGenerateKeyCallback(oKey);
    }
  }, this))["catch"](_.bind(function (oError) {
    if (_.isFunction(fOnErrorCallback)) {
      fOnErrorCallback();
    }
    this.onKeyGenerateError(oError);
  }, this));
};

/**
 * Read key name from local storage
 */
CJscryptoKey.prototype.loadKeyNameFromStorage = function () {
  if (Storage.hasData(this.getStorageName())) {
    this.keyName(Storage.getData(this.getStorageName()).keyname);
  }
};

/**
 *  read key data from local storage
 *
 *  @returns {string}
 */
CJscryptoKey.prototype.loadKeyFromStorage = function () {
  var sKey = '';
  if (Storage.hasData(this.getStorageName())) {
    sKey = Storage.getData(this.getStorageName()).keydata;
  }
  return sKey;
};

/**
 * Asynchronously generate key object from array data
 *
 * @param {ArrayBuffer} aKey
 * @returns {Promise}
 */
CJscryptoKey.prototype.generateKeyFromArray = function (aKey) {
  var keyPromise = window.crypto.subtle.importKey("raw", aKey, {
    name: "AES-CBC"
  }, true, ["encrypt", "decrypt"]);
  return keyPromise;
};

/**
 * Write key-object to knockout variable
 *
 * @param {Object} oKey
 */
CJscryptoKey.prototype.onKeyGenerateSuccess = function (oKey) {
  this.key(oKey);
};

/**
 * Show error message
 *
 * @param {Object} oError
 */
CJscryptoKey.prototype.onKeyGenerateError = function (oError) {
  if (oError && oError.message) {
    Screens.showError(oError.message);
  }
};

/**
 * Asynchronously generate new key
 */
CJscryptoKey.prototype.generateKey = /*#__PURE__*/_asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee() {
  var oKey, _t;
  return _regenerator().w(function (_context) {
    while (1) switch (_context.p = _context.n) {
      case 0:
        oKey = false;
        _context.p = 1;
        _context.n = 2;
        return window.crypto.subtle.generateKey({
          name: "AES-CBC",
          length: 256
        }, true, ["encrypt", "decrypt"]);
      case 2:
        oKey = _context.v;
        _context.n = 4;
        break;
      case 3:
        _context.p = 3;
        _t = _context.v;
        Screens.showError(TextUtils.i18n('COREPARANOIDENCRYPTIONWEBCLIENTPLUGIN/ERROR_GENERATE_KEY'));
      case 4:
        return _context.a(2, oKey);
    }
  }, _callee, null, [[1, 3]]);
}));
CJscryptoKey.prototype.convertKeyToString = /*#__PURE__*/function () {
  var _ref2 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee2(oKey) {
    var sKeyData, aKeyData, _t2;
    return _regenerator().w(function (_context2) {
      while (1) switch (_context2.p = _context2.n) {
        case 0:
          sKeyData = '';
          if (!oKey) {
            _context2.n = 4;
            break;
          }
          _context2.p = 1;
          _context2.n = 2;
          return window.crypto.subtle.exportKey("raw", oKey);
        case 2:
          aKeyData = _context2.v;
          sKeyData = HexUtils.Array2HexString(new Uint8Array(aKeyData));
          _context2.n = 4;
          break;
        case 3:
          _context2.p = 3;
          _t2 = _context2.v;
          Screens.showError(TextUtils.i18n('COREPARANOIDENCRYPTIONWEBCLIENTPLUGIN/ERROR_EXPORT_KEY'));
        case 4:
          return _context2.a(2, sKeyData);
      }
    }, _callee2, null, [[1, 3]]);
  }));
  return function (_x) {
    return _ref2.apply(this, arguments);
  };
}();

/**
 * Asynchronously generate and export new key
 *
 * @param {Function} fOnGenerateCallback - starts after the key is successfully generated
 * @param {string} sKeyName
 */
CJscryptoKey.prototype.generateAndExportKey = /*#__PURE__*/function () {
  var _ref3 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee4(fOnGenerateCallback, sKeyName) {
    var _this = this;
    var oKey, sKeyData;
    return _regenerator().w(function (_context4) {
      while (1) switch (_context4.n) {
        case 0:
          _context4.n = 1;
          return this.generateKey();
        case 1:
          oKey = _context4.v;
          _context4.n = 2;
          return this.convertKeyToString(oKey);
        case 2:
          sKeyData = _context4.v;
          Popups.showPopup(EncryptKeyPasswordPopup, [(/*#__PURE__*/function () {
            var _ref4 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee3(sPassword) {
              var sKeyDataEncrypted, _t3;
              return _regenerator().w(function (_context3) {
                while (1) switch (_context3.p = _context3.n) {
                  case 0:
                    _context3.p = 0;
                    _context3.n = 1;
                    return _this.encryptKeyData(sKeyData, sPassword);
                  case 1:
                    sKeyDataEncrypted = _context3.v;
                    Storage.setData(_this.getStorageName(), {
                      keyname: sKeyName,
                      keydata: sKeyDataEncrypted
                    });
                    _this.loadKeyNameFromStorage();
                    _this.onKeyGenerateSuccess(oKey);
                    if (_.isFunction(fOnGenerateCallback)) {
                      fOnGenerateCallback();
                    }
                    _context3.n = 3;
                    break;
                  case 2:
                    _context3.p = 2;
                    _t3 = _context3.v;
                    Screens.showError(TextUtils.i18n('COREPARANOIDENCRYPTIONWEBCLIENTPLUGIN/ERROR_LOAD_KEY'));
                  case 3:
                    return _context3.a(2);
                }
              }, _callee3, null, [[0, 2]]);
            }));
            return function (_x4) {
              return _ref4.apply(this, arguments);
            };
          }()), function () {}]);
        case 3:
          return _context4.a(2);
      }
    }, _callee4, this);
  }));
  return function (_x2, _x3) {
    return _ref3.apply(this, arguments);
  };
}();
CJscryptoKey.prototype.getKeyFromString = /*#__PURE__*/function () {
  var _ref5 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee5(sParanoidKey) {
    var oKey, aKeyData, _t4;
    return _regenerator().w(function (_context5) {
      while (1) switch (_context5.p = _context5.n) {
        case 0:
          oKey = null;
          aKeyData = HexUtils.HexString2Array(sParanoidKey);
          if (aKeyData.length > 0) {
            aKeyData = new Uint8Array(aKeyData);
          } else {
            Screens.showError(TextUtils.i18n('COREPARANOIDENCRYPTIONWEBCLIENTPLUGIN/ERROR_LOAD_KEY'));
          }
          _context5.p = 1;
          _context5.n = 2;
          return this.generateKeyFromArray(aKeyData);
        case 2:
          oKey = _context5.v;
          _context5.n = 4;
          break;
        case 3:
          _context5.p = 3;
          _t4 = _context5.v;
          Screens.showError(TextUtils.i18n('COREPARANOIDENCRYPTIONWEBCLIENTPLUGIN/ERROR_LOAD_KEY'));
        case 4:
          return _context5.a(2, oKey);
      }
    }, _callee5, this, [[1, 3]]);
  }));
  return function (_x5) {
    return _ref5.apply(this, arguments);
  };
}();

/**
 * Asynchronously generate key-object from string key-data
 *
 * @param {string} sKeyName
 * @param {string} sKeyData
 * @param {Function} fOnImportKeyCallback - starts after the key is successfully imported
 * @param {Function} fOnErrorCallback - starts if an error occurs during the key import process
 */
CJscryptoKey.prototype.importKeyFromString = function (sKeyName, sKeyData, fOnImportKeyCallback, fOnErrorCallback) {
  try {
    Popups.showPopup(EncryptKeyPasswordPopup, [_.bind(function (sPassword) {
      // Encrypt imported Key with User password
      this.encryptKeyData(sKeyData, sPassword).then(_.bind(function (sKeyDataEncrypted) {
        // Store encrypted key in local storage
        Storage.setData(this.getStorageName(), {
          keyname: sKeyName,
          keydata: sKeyDataEncrypted
        });
        this.getKey(fOnImportKeyCallback, fOnErrorCallback, sPassword);
      }, this))["catch"](function () {
        Screens.showError(TextUtils.i18n('COREPARANOIDENCRYPTIONWEBCLIENTPLUGIN/ERROR_LOAD_KEY'));
        if (_.isFunction(fOnErrorCallback)) {
          fOnErrorCallback();
        }
      });
    }, this), function () {
      // Cancel callback
      if (_.isFunction(fOnErrorCallback)) {
        fOnErrorCallback();
      }
    }]);
  } catch (e) {
    Screens.showError(TextUtils.i18n('COREPARANOIDENCRYPTIONWEBCLIENTPLUGIN/ERROR_IMPORT_KEY'));
    if (_.isFunction(fOnErrorCallback)) {
      fOnErrorCallback();
    }
  }
};

/**
 * Asynchronously export key
 *
 * @returns {Promise}
 */
CJscryptoKey.prototype.exportKey = function () {
  return window.crypto.subtle.exportKey("raw", this.key());
};

/**
 * Remove key-object and clear key-data in local storage
 *
 * @returns {Object}
 */
CJscryptoKey.prototype.deleteKey = function () {
  try {
    this.key(null);
    this.keyName(null);
    Storage.removeData(this.getStorageName());
  } catch (e) {
    return {
      error: e
    };
  }
  return {
    status: 'ok'
  };
};

/**
 * Asynchronously decrypt key with user password
 *
 * @param {string} sEncryptedKeyData
 * @param {string} sPassword
 * @returns {Promise}
 */
CJscryptoKey.prototype.decryptKeyData = function (sEncryptedKeyData, sPassword) {
  var aVector = new Uint8Array(16) //defaults to zero
  ;
  return new Promise(function (resolve, reject) {
    if (!sEncryptedKeyData) {
      reject(new Error(TextUtils.i18n('COREPARANOIDENCRYPTIONWEBCLIENTPLUGIN/ERROR_LOAD_KEY')));
    } else {
      //get password-key
      this.deriveKeyFromPasswordPromise(sPassword, _.bind(function (oDerivedKey) {
        crypto.subtle.decrypt({
          name: 'AES-CBC',
          iv: aVector
        }, oDerivedKey, new Uint8Array(HexUtils.HexString2Array(sEncryptedKeyData))).then(_.bind(function (aDecryptedKeyData) {
          resolve(new Uint8Array(aDecryptedKeyData));
        }, this))["catch"](function () {
          reject(new Error(TextUtils.i18n('COREPARANOIDENCRYPTIONWEBCLIENTPLUGIN/ERROR_LOAD_KEY')));
        });
      }, this), function () {
        reject(new Error(TextUtils.i18n('COREPARANOIDENCRYPTIONWEBCLIENTPLUGIN/ERROR_LOAD_KEY')));
      });
    }
  }.bind(this));
};

/**
 * Asynchronously encrypt key with user password
 *
 * @param {string} sUserKeyData
 * @param {string} sPassword
 * @returns {Promise}
 */
CJscryptoKey.prototype.encryptKeyData = function (sUserKeyData, sPassword) {
  var aKeyData = null,
    sEncryptedKeyData = null,
    aVector = new Uint8Array(16) //defaults to zero
  ;
  return new Promise(function (resolve, reject) {
    if (!sUserKeyData) {
      reject(new Error(TextUtils.i18n('COREPARANOIDENCRYPTIONWEBCLIENTPLUGIN/ERROR_LOAD_KEY')));
    } else {
      aKeyData = HexUtils.HexString2Array(sUserKeyData);
      if (aKeyData.length > 0) {
        aKeyData = new Uint8Array(aKeyData);
      } else {
        reject(new Error(TextUtils.i18n('COREPARANOIDENCRYPTIONWEBCLIENTPLUGIN/ERROR_LOAD_KEY')));
      }
      //get password-key
      this.deriveKeyFromPasswordPromise(sPassword, _.bind(function (oDerivedKey) {
        //encrypt user-key with password-key
        crypto.subtle.encrypt({
          name: 'AES-CBC',
          iv: aVector
        }, oDerivedKey, aKeyData).then(_.bind(function (aEncryptedKeyData) {
          sEncryptedKeyData = HexUtils.Array2HexString(new Uint8Array(aEncryptedKeyData));
          resolve(sEncryptedKeyData);
        }, this))["catch"](function () {
          reject(new Error(TextUtils.i18n('COREPARANOIDENCRYPTIONWEBCLIENTPLUGIN/ERROR_LOAD_KEY')));
        });
      }, this), function () {
        reject(new Error(TextUtils.i18n('COREPARANOIDENCRYPTIONWEBCLIENTPLUGIN/ERROR_LOAD_KEY')));
      });
    }
  }.bind(this));
};

/**
 * Asynchronously generate special key from user password. This key used in process of encryption/decryption user key.
 *
 * @param {string} sPassword
 * @param {Function} fOnGetDerivedKeyCallback - starts after the key is successfully generated
 * @param {Function} fOnErrorCallback - starts if an error occurs during the key generation process
 */
CJscryptoKey.prototype.deriveKeyFromPasswordPromise = function (sPassword, fOnGetDerivedKeyCallback, fOnErrorCallback) {
  var convertStringToArrayBuffer = function convertStringToArrayBuffer(sData) {
    if (window.TextEncoder) {
      return new TextEncoder('utf-8').encode(sData);
    }
    var sUtf8 = unescape(encodeURIComponent(sData)),
      sResult = new Uint8Array(sUtf8.length);
    for (var i = 0; i < sUtf8.length; i++) {
      sResult[i] = sUtf8.charCodeAt(i);
    }
    return sResult;
  };
  window.crypto.subtle.importKey("raw", convertStringToArrayBuffer(sPassword), {
    "name": "PBKDF2"
  }, false, ["deriveKey"]).then(_.bind(function (oPasswordKey) {
    window.crypto.subtle.deriveKey({
      "name": "PBKDF2",
      "salt": window.crypto.getRandomValues(new Uint8Array(16)),
      "iterations": 100000,
      "hash": "SHA-256"
    }, oPasswordKey, {
      "name": "AES-CBC",
      "length": 256
    }, true, ["encrypt", "decrypt"]).then(function (oDerivedKey) {
      if (_.isFunction(fOnGetDerivedKeyCallback)) {
        fOnGetDerivedKeyCallback(oDerivedKey);
      }
    })["catch"](function () {
      if (_.isFunction(fOnErrorCallback)) {
        fOnErrorCallback();
      }
    });
  }, this))["catch"](function () {
    if (_.isFunction(fOnErrorCallback)) {
      fOnErrorCallback();
    }
  });
};
CJscryptoKey.prototype.getStorageName = function () {
  var userId = UserSettings.UserId || 0;
  return "aurora_paranoid_user_".concat(userId, "_encrypted-crypto-key");
};
module.exports = new CJscryptoKey();

/***/ }),

/***/ "oMpj":
/*!********************************************************************************************!*\
  !*** ./modules/CoreParanoidEncryptionWebclientPlugin/js/popups/EncryptKeyPasswordPopup.js ***!
  \********************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

/* provided dependency */ var $ = __webpack_require__(/*! jquery */ "M4cL");


var _ = __webpack_require__(/*! underscore */ "C3HO"),
  ko = __webpack_require__(/*! knockout */ "p09A"),
  CAbstractPopup = __webpack_require__(/*! modules/CoreWebclient/js/popups/CAbstractPopup.js */ "69av"),
  TextUtils = __webpack_require__(/*! modules/CoreWebclient/js/utils/Text.js */ "LKDt"),
  Screens = __webpack_require__(/*! modules/CoreWebclient/js/Screens.js */ "D2Gh");

/**
 * @constructor
 */
function CEncryptKeyPasswordPopup() {
  CAbstractPopup.call(this);
  this.keyPassword = ko.observable('');
  this.keyPasswordConfirm = ko.observable('');
  this.fOnPasswordEnterCallback = null;
  this.fOnWrongPasswordCallback = null;
  this.fOnCancellCallback = null;
}
_.extendOwn(CEncryptKeyPasswordPopup.prototype, CAbstractPopup.prototype);
CEncryptKeyPasswordPopup.prototype.PopupTemplate = 'CoreParanoidEncryptionWebclientPlugin_EncryptKeyPasswordPopup';
CEncryptKeyPasswordPopup.prototype.onOpen = function (fOnPasswordEnterCallback, fOnCancellCallback) {
  this.fOnPasswordEnterCallback = fOnPasswordEnterCallback;
  this.fOnCancellCallback = fOnCancellCallback;
};
CEncryptKeyPasswordPopup.prototype.encryptKey = function () {
  if ($.trim(this.keyPassword()) === '') {
    this.showError(TextUtils.i18n('COREPARANOIDENCRYPTIONWEBCLIENTPLUGIN/ERROR_PASSWORD_CANT_BE_BLANK'));
  } else if ($.trim(this.keyPassword()) !== $.trim(this.keyPasswordConfirm())) {
    this.showError(TextUtils.i18n('COREWEBCLIENT/ERROR_PASSWORDS_DO_NOT_MATCH'));
  } else {
    if (_.isFunction(this.fOnPasswordEnterCallback)) {
      this.fOnPasswordEnterCallback($.trim(this.keyPassword()));
    }
    this.closePopup();
  }
};
CEncryptKeyPasswordPopup.prototype.cancelPopup = function () {
  if (_.isFunction(this.fOnCancellCallback)) {
    this.fOnCancellCallback();
  }
  this.closePopup();
};
CEncryptKeyPasswordPopup.prototype.onShow = function () {
  this.keyPassword('');
  this.keyPasswordConfirm('');
};
CEncryptKeyPasswordPopup.prototype.showError = function (sMessage) {
  Screens.showError(sMessage);
};
module.exports = new CEncryptKeyPasswordPopup();

/***/ }),

/***/ "v25v":
/*!***********************************************************************!*\
  !*** ./modules/CoreParanoidEncryptionWebclientPlugin/js/utils/Hex.js ***!
  \***********************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {



var _ = __webpack_require__(/*! underscore */ "C3HO"),
  HexUtils = {};
HexUtils.Array2HexString = function (aInput) {
  var sHexAB = '';
  _.each(aInput, function (element) {
    var sHex = element.toString(16);
    sHexAB += (sHex.length === 1 ? '0' : '') + sHex;
  });
  return sHexAB;
};
HexUtils.HexString2Array = function (sHex) {
  var aResult = [];
  if (sHex.length === 0 || sHex.length % 2 !== 0) {
    return aResult;
  }
  for (var i = 0; i < sHex.length; i += 2) {
    aResult.push(parseInt(sHex.substr(i, 2), 16));
  }
  return aResult;
};
module.exports = HexUtils;

/***/ }),

/***/ "wOV2":
/*!********************************************************************************************!*\
  !*** ./modules/CoreParanoidEncryptionWebclientPlugin/js/popups/DecryptKeyPasswordPopup.js ***!
  \********************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {



var _ = __webpack_require__(/*! underscore */ "C3HO"),
  ko = __webpack_require__(/*! knockout */ "p09A"),
  CAbstractPopup = __webpack_require__(/*! modules/CoreWebclient/js/popups/CAbstractPopup.js */ "69av");

/**
 * @constructor
 */
function CDecryptKeyPasswordPopup() {
  CAbstractPopup.call(this);
  this.keyPassword = ko.observable('');
  this.fOnPasswordEnterCallback = null;
  this.fOnCancellCallback = null;
}
_.extendOwn(CDecryptKeyPasswordPopup.prototype, CAbstractPopup.prototype);
CDecryptKeyPasswordPopup.prototype.PopupTemplate = 'CoreParanoidEncryptionWebclientPlugin_DecryptKeyPasswordPopup';
CDecryptKeyPasswordPopup.prototype.onOpen = function (fOnPasswordEnterCallback, fOnCancellCallback) {
  this.fOnPasswordEnterCallback = fOnPasswordEnterCallback;
  this.fOnCancellCallback = fOnCancellCallback;
};
CDecryptKeyPasswordPopup.prototype.decryptKey = function () {
  if (_.isFunction(this.fOnPasswordEnterCallback)) {
    this.fOnPasswordEnterCallback(this.keyPassword());
  }
  this.closePopup();
};
CDecryptKeyPasswordPopup.prototype.cancelPopup = function () {
  if (_.isFunction(this.fOnCancellCallback)) {
    this.fOnCancellCallback();
  }
  this.closePopup();
};
CDecryptKeyPasswordPopup.prototype.onShow = function () {
  this.keyPassword('');
};
module.exports = new CDecryptKeyPasswordPopup();

/***/ })

}]);