(self["webpackChunkafterlogic_aurora_platform"] = self["webpackChunkafterlogic_aurora_platform"] || []).push([[40],{

/***/ "59vb":
/*!***************************************************************************!*\
  !*** ./modules/RocketChatWebclient/js/views/AddMeetingLinkToEventView.js ***!
  \***************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var ko = __webpack_require__(/*! knockout */ "p09A"),
  ContenteditableUtils = __webpack_require__(/*! modules/CoreWebclient/js/utils/Contenteditable.js */ "7VXH"),
  Utils = __webpack_require__(/*! modules/CoreWebclient/js/utils/Common.js */ "uQaC"),
  Settings = __webpack_require__(/*! modules/RocketChatWebclient/js/Settings.js */ "Mrin");
function CAddMeetingLinkToEventView() {
  this.meetingLinkUrl = Settings.MeetingLinkUrl.replace(/[^\/]$/, '$&/'); //adding '/' at the end if it's missing
  this.allowAddMeetingLink = Settings.AllowAddMeetingLinkToEvent && Settings.MeetingLinkUrl.length !== 0;
  this.focusedDom = ko.observable(null);
}
CAddMeetingLinkToEventView.prototype.ViewTemplate = 'RocketChatWebclient_AddMeetingLinkToEventView';
CAddMeetingLinkToEventView.prototype.init = function (view) {
  this.isEditable = view.descriptionView.isEditable;
  this.descriptionDom = view.descriptionView.dataDom;
  this.descriptionHtml = view.descriptionView.dataHtml;
  this.descriptionFocus = view.descriptionView.dataFocus;
  this.descriptionFocus.subscribe(function () {
    if (this.descriptionFocus()) {
      this.focusedDom(this.descriptionDom());
    } else {
      this.savedRanges = ContenteditableUtils.getSelectionRanges();
      setTimeout(function () {
        if (!this.descriptionFocus() && !this.locationFocus()) {
          this.focusedDom(null);
        }
      }.bind(this), 100);
    }
  }, this);
  this.locationDom = view.locationView.dataDom;
  this.locationHtml = view.locationView.dataHtml;
  this.locationFocus = view.locationView.dataFocus;
  this.locationFocus.subscribe(function () {
    if (this.locationFocus()) {
      this.focusedDom(this.locationDom());
    } else {
      setTimeout(function () {
        if (!this.descriptionFocus() && !this.locationFocus()) {
          this.focusedDom(null);
        }
      }.bind(this), 100);
    }
  }, this);
};
CAddMeetingLinkToEventView.prototype.addMeetingLink = function () {
  var meetingLinkUrl = this.meetingLinkUrl,
    meetingId = Utils.getRandomHash(32),
    url = "".concat(meetingLinkUrl).concat(meetingId),
    html = "<a href=\"".concat(url, "\">").concat(url, "</a>");
  if (this.focusedDom()) {
    // insert where the cursor is
    ContenteditableUtils.setSelectionRanges(this.savedRanges, true);
    this.focusedDom().focus();
    window.document.execCommand('insertHTML', false, html);
  } else {
    // insert at the end
    ContenteditableUtils.setCursorAtTheEnd(this.locationDom()[0]);
    window.document.execCommand('insertHTML', false, html);
  }
  if (this.descriptionFocus()) {
    this.descriptionHtml(this.descriptionDom().html());
  } else if (this.locationFocus()) {
    this.locationHtml(this.locationDom().html());
  }
  //	if (this.descriptionDom && document.createRange && window.getSelection) {
  //		console.log('this.descriptionDom', this.descriptionDom());
  //		const
  //			range = document.createRange(),
  //			selection = window.getSelection()
  //		;
  //
  //		range.selectNodeContents(this.descriptionDom());
  //		selection.removeAllRanges();
  //		selection.addRange(range);
  //
  //		window.document.execCommand('unlink');
  //		this.currLink = null;
  //		this.hideLinkPopup();
  //	}
};
module.exports = new CAddMeetingLinkToEventView();

/***/ }),

/***/ "7VXH":
/*!***********************************************************!*\
  !*** ./modules/CoreWebclient/js/utils/Contenteditable.js ***!
  \***********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var _ = __webpack_require__(/*! underscore */ "C3HO");
var ContenteditableUtils = {};
ContenteditableUtils.setCursorAtTheEnd = function (contentEditableElement) {
  if (document.createRange) {
    var range = document.createRange();
    range.selectNodeContents(contentEditableElement);
    range.collapse(false);
    var selection = window.getSelection();
    selection.removeAllRanges();
    selection.addRange(range);
    contentEditableElement.focus();
    range.detach();
  }
};
ContenteditableUtils.getSelectionRanges = function () {
  var ranges = [];
  if (window.getSelection) {
    var selection = window.getSelection(),
      count = selection.rangeCount;
    for (var index = 0; index < count; index++) {
      ranges.push(selection.getRangeAt(index));
    }
  }
  return ranges;
};
ContenteditableUtils.setSelectionRanges = function (ranges) {
  var collapse = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
  var rangeText = '';
  if (window.getSelection && _.isArray(ranges)) {
    var count = ranges.length,
      selection = window.getSelection();
    selection.removeAllRanges();
    for (var index = 0; index < count; index++) {
      var range = ranges[index];
      if (range) {
        selection.addRange(range);
        rangeText += range;
        if (collapse) {
          range.collapse(false);
        }
      }
    }
  }
  return rangeText;
};
module.exports = ContenteditableUtils;

/***/ }),

/***/ "7rNz":
/*!**********************************************************!*\
  !*** ./modules/RocketChatWebclient/js/views/MainView.js ***!
  \**********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var _ = __webpack_require__(/*! underscore */ "C3HO"),
  ko = __webpack_require__(/*! knockout */ "p09A"),
  Types = __webpack_require__(/*! modules/CoreWebclient/js/utils/Types.js */ "ERH9"),
  Utils = __webpack_require__(/*! modules/CoreWebclient/js/utils/Common.js */ "uQaC"),
  Ajax = __webpack_require__(/*! modules/CoreWebclient/js/Ajax.js */ "8QQh"),
  Screens = __webpack_require__(/*! modules/CoreWebclient/js/Screens.js */ "D2Gh"),
  TextUtils = __webpack_require__(/*! modules/CoreWebclient/js/utils/Text.js */ "LKDt"),
  CAbstractScreenView = __webpack_require__(/*! modules/CoreWebclient/js/views/CAbstractScreenView.js */ "db2p"),
  Routing = __webpack_require__(/*! modules/CoreWebclient/js/Routing.js */ "ioSH"),
  UserSettings = __webpack_require__(/*! modules/CoreWebclient/js/Settings.js */ "KIwC"),
  Settings = __webpack_require__(/*! modules/RocketChatWebclient/js/Settings.js */ "Mrin"),
  HeaderItemView = __webpack_require__(/*! modules/RocketChatWebclient/js/views/HeaderItemView.js */ "gSOl");

/**
 * View that is used as screen of the module. Inherits from CAbstractScreenView that has showing and hiding methods.
 * 
 * @constructor
 */
function CMainView() {
  CAbstractScreenView.call(this, 'RocketChatWebclient');
  this.initialized = ko.observable(false);
  this.sChatUrl = Settings.ChatUrl;
  this.iframeDom = ko.observable(null);
  this.iframeLoaded = ko.observable(false);
  this.chatToken = ko.observable('');
  this.infoMessage = ko.observable(TextUtils.i18n('COREWEBCLIENT/INFO_LOADING'));
  ko.computed(function () {
    if (this.iframeDom() && this.chatToken() && this.iframeLoaded()) {
      this.init();
    }
  }, this);
  Ajax.send(Settings.ServerModuleName, 'InitChat', {}, function (oResponse) {
    if (oResponse.Result && oResponse.Result['authToken']) {
      this.chatToken(oResponse.Result['authToken']);
      HeaderItemView.unseenCount(Types.pInt(oResponse.Result['unreadCounter']));
    } else {
      this.infoMessage(TextUtils.i18n('ROCKETCHATWEBCLIENT/ERROR_INIT_CHAT'));
    }
  }, this);
  this.iframeDom.subscribe(function (iframeDom) {
    var _this = this;
    iframeDom[0].addEventListener('load', function () {
      window.addEventListener('message', function (oEvent) {
        if (oEvent && oEvent.data && this.iframeDom() && oEvent.source === this.iframeDom()[0].contentWindow) {
          // for whatever reason the event isn't sent since RC 7.9.0, so we assume it's loaded if any message is received
          // if(oEvent.data.eventName === 'startup') {
          this.iframeLoaded(true);
          // }
          if (oEvent.data.eventName === 'notification') {
            this.showNotification(oEvent.data.data.notification);
          }
          if (oEvent.data.eventName === 'unread-changed') {
            HeaderItemView.unseenCount(Types.pInt(oEvent.data.data));
          }
        }
      }.bind(_this));
    });
  }, this);
}
_.extendOwn(CMainView.prototype, CAbstractScreenView.prototype);
CMainView.prototype.ViewTemplate = 'RocketChatWebclient_MainView';
CMainView.prototype.ViewConstructorName = 'CMainView';
CMainView.prototype.init = function () {
  if (!this.initialized()) {
    var iframe = document.getElementById('rocketchat_iframe'),
      self = this;
    iframe.contentWindow.postMessage({
      externalCommand: 'login-with-token',
      token: self.chatToken()
    }, '*');
    setTimeout(function () {
      iframe.contentWindow.postMessage({
        externalCommand: 'set-aurora-theme',
        theme: UserSettings.Theme
      }, '*');
      self.initialized(true);
    }, 2000);
  }
};
CMainView.prototype.showNotification = function (oNotification) {
  var oParameters = {
    action: 'show',
    icon: this.sChatUrl + 'avatar/' + oNotification.payload.sender.username + '?size=50&format=png',
    title: oNotification.title,
    body: oNotification.text,
    callback: function () {
      window.focus();
      if (!this.shown()) {
        Routing.setHash([Settings.HashModuleName]);
      }
      var sPath = '';
      switch (oNotification.payload.type) {
        case 'c':
          sPath = '/channel/' + oNotification.payload.name;
          break;
        case 'd':
          sPath = '/direct/' + oNotification.payload.rid;
          break;
        case 'p':
          sPath = '/group/' + oNotification.payload.name;
          break;
      }
      if (sPath) {
        this.iframeDom()[0].contentWindow.postMessage({
          externalCommand: 'go',
          path: sPath
        }, '*');
      }
    }.bind(this)
  };
  Utils.desktopNotify(oParameters);
};
module.exports = new CMainView();

/***/ }),

/***/ "EW18":
/*!***************************************************!*\
  !*** ./modules/RocketChatWebclient/js/manager.js ***!
  \***************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var $ = __webpack_require__(/*! jquery */ "M4cL");


module.exports = function (oAppData) {
  var ko = __webpack_require__(/*! knockout */ "p09A"),
    App = __webpack_require__(/*! modules/CoreWebclient/js/App.js */ "yU9o"),
    TextUtils = __webpack_require__(/*! modules/CoreWebclient/js/utils/Text.js */ "LKDt"),
    Settings = __webpack_require__(/*! modules/RocketChatWebclient/js/Settings.js */ "Mrin"),
    WindowOpener = __webpack_require__(/*! modules/CoreWebclient/js/WindowOpener.js */ "zVyH"),
    oOpenedWindows = [],
    HeaderItemView = null;
  Settings.init(oAppData);
  var sAppHash = Settings.AppName ? TextUtils.getUrlFriendlyName(Settings.AppName) : Settings.HashModuleName;
  if (App.isUserNormalOrTenant()) {
    var result = {
      /**
       * Returns list of functions that are return module screens.
       * 
       * @returns {Object}
       */
      getScreens: function getScreens() {
        var oScreens = {};
        oScreens[Settings.HashModuleName] = function () {
          return __webpack_require__(/*! modules/RocketChatWebclient/js/views/MainView.js */ "7rNz");
        };
        return oScreens;
      }
    };
    if (!App.isNewTab()) {
      App.subscribeEvent('CalendarWebclient::RegisterEditEventController', function (_ref) {
        var register = _ref.register,
          view = _ref.view;
        var controller = __webpack_require__(/*! modules/RocketChatWebclient/js/views/AddMeetingLinkToEventView.js */ "59vb");
        controller.init(view);
        register(controller, 'AdditionalButton');
      });
      result.start = function (ModulesManager) {
        // init screen so the module could interact with chat in iframe
        var Screens = __webpack_require__(/*! modules/CoreWebclient/js/Screens.js */ "D2Gh");
        Screens.initHiddenView(Settings.HashModuleName);
        if (Settings.ChatUrl !== '') {
          ModulesManager.run('SettingsWebclient', 'registerSettingsTab', [function () {
            return __webpack_require__(/*! modules/RocketChatWebclient/js/views/RocketChatSettingsPaneView.js */ "aZaw");
          }, Settings.HashModuleName, TextUtils.i18n('ROCKETCHATWEBCLIENT/LABEL_SETTINGS_TAB')]);
        }
        App.subscribeEvent('Logout', function () {
          if ($('#rocketchat_iframe')) {
            $('#rocketchat_iframe').hide();
            $('#rocketchat_iframe').get(0).contentWindow.postMessage({
              externalCommand: 'logout'
            }, '*');
          }
        });
        if (Settings.ChatUrl !== '') {
          App.subscribeEvent('ContactsWebclient::AddCustomCommand', function (oParams) {
            oParams.Callback({
              'Text': TextUtils.i18n('ROCKETCHATWEBCLIENT/ACTION_CHAT_WITH_CONTACT'),
              'CssClass': 'chat',
              'Handler': function Handler() {
                var oWin = oOpenedWindows[this.uuid()];
                if (oWin && !oWin.closed) {
                  oWin.focus();
                } else {
                  var iScreenWidth = window.screen.width,
                    iWidth = 360,
                    iLeft = Math.ceil((iScreenWidth - iWidth) / 2),
                    iScreenHeight = window.screen.height,
                    iHeight = 600,
                    iTop = Math.ceil((iScreenHeight - iHeight) / 2),
                    sUrl = '?chat-direct=' + this.uuid() + '&' + new Date().getTime(),
                    sName = 'Chat',
                    sSize = ',width=' + iWidth + ',height=' + iHeight + ',top=' + iTop + ',left=' + iLeft;
                  oWin = WindowOpener.open(sUrl, sName, false, sSize);
                  if (oWin) {
                    oOpenedWindows[this.uuid()] = oWin;
                  }
                }
              },
              'Visible': ko.computed(function () {
                return oParams.Contact.team() && !oParams.Contact.itsMe();
              })
            });
          });
        }
      };

      /**
       * Returns object of header item view of the module.
       * 
       * @returns {Object}
       */
      result.getHeaderItem = function () {
        if (HeaderItemView === null) {
          HeaderItemView = __webpack_require__(/*! modules/RocketChatWebclient/js/views/HeaderItemView.js */ "gSOl");
        }
        if (Settings.ChatUrl !== '') {
          return {
            item: HeaderItemView,
            name: sAppHash
          };
        }
      };
    }
    return result;
  }
  return null;
};

/***/ }),

/***/ "Mrin":
/*!****************************************************!*\
  !*** ./modules/RocketChatWebclient/js/Settings.js ***!
  \****************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var _ = __webpack_require__(/*! underscore */ "C3HO"),
  Types = __webpack_require__(/*! modules/CoreWebclient/js/utils/Types.js */ "ERH9");
module.exports = {
  ServerModuleName: 'RocketChatWebclient',
  HashModuleName: 'chat',
  ChatUrl: '',
  AllowAddMeetingLinkToEvent: false,
  MeetingLinkUrl: '',
  /**
   * Initializes settings from AppData object sections.
   * 
   * @param {Object} oAppData Object contained modules settings.
   */
  init: function init(oAppData) {
    var oAppDataSection = oAppData['RocketChatWebclient'];
    if (!_.isEmpty(oAppDataSection)) {
      this.ChatUrl = Types.pString(oAppDataSection.ChatUrl);
      this.AllowAddMeetingLinkToEvent = Types.pBool(oAppDataSection.AllowAddMeetingLinkToEvent);
      this.MeetingLinkUrl = Types.pString(oAppDataSection.MeetingLinkUrl);
    }
  }
};

/***/ }),

/***/ "TFLG":
/*!************************************************!*\
  !*** ./modules/RocketChatWebclient/js/Ajax.js ***!
  \************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var Ajax = __webpack_require__(/*! modules/CoreWebclient/js/Ajax.js */ "8QQh"),
  Settings = __webpack_require__(/*! modules/RocketChatWebclient/js/Settings.js */ "Mrin");
module.exports = {
  send: function send(sMethod, oParameters, fResponseHandler, oContext, sServerModuleName) {
    Ajax.send(sServerModuleName ? sServerModuleName : Settings.ServerModuleName, sMethod, oParameters, fResponseHandler, oContext);
  }
};

/***/ }),

/***/ "aZaw":
/*!****************************************************************************!*\
  !*** ./modules/RocketChatWebclient/js/views/RocketChatSettingsPaneView.js ***!
  \****************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var App = __webpack_require__(/*! modules/CoreWebclient/js/App.js */ "yU9o"),
  Ajax = __webpack_require__(/*! modules/RocketChatWebclient/js/Ajax.js */ "TFLG"),
  TextUtils = __webpack_require__(/*! modules/CoreWebclient/js/utils/Text.js */ "LKDt"),
  Settings = __webpack_require__(/*! modules/RocketChatWebclient/js/Settings.js */ "Mrin"),
  UserSettings = __webpack_require__(/*! modules/CoreWebclient/js/Settings.js */ "KIwC");

/**
 * @constructor
 */
function CRocketChatSettingsPaneView() {
  this.sAppName = Settings.AppName || TextUtils.i18n('ROCKETCHATWEBCLIENT/LABEL_SETTINGS_TAB');
  this.server = Settings.ChatUrl;
  this.bDemo = UserSettings.IsDemo;
  this.sDownloadLink = 'https://www.rocket.chat/download-apps';

  // this.sLogin = ko.observable('');
  // this.getLoginForCurrentUser();
  // this.credentialsHintText = ko.computed(function () {
  // 	return TextUtils.i18n('ROCKETCHATWEBCLIENT/INFO_CREDENTIALS', {'LOGIN': this.sLogin()});
  // }, this);

  this.credentialsHintText = App.mobileCredentialsHintText;
}
CRocketChatSettingsPaneView.prototype.getLoginForCurrentUser = function () {
  Ajax.send('GetLoginForCurrentUser', {}, function (oResponse) {
    this.sLogin(oResponse.Result);
  }, this);
};

/**
 * Name of template that will be bound to this JS-object.
 */
CRocketChatSettingsPaneView.prototype.ViewTemplate = 'RocketChatWebclient_RocketChatSettingsPaneView';
module.exports = new CRocketChatSettingsPaneView();

/***/ }),

/***/ "cR1d":
/*!***********************************************************!*\
  !*** ./modules/CoreWebclient/js/views/CHeaderItemView.js ***!
  \***********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var ko = __webpack_require__(/*! knockout */ "p09A"),
  Routing = __webpack_require__(/*! modules/CoreWebclient/js/Routing.js */ "ioSH");
function CHeaderItemView(sLinkText) {
  this.sName = '';
  this.visible = ko.observable(true);
  this.baseHash = ko.observable('');
  this.hash = ko.observable('');
  this.linkText = ko.observable(sLinkText);
  this.isCurrent = ko.observable(false);
  this.recivedAnim = ko.observable(false).extend({
    'autoResetToFalse': 500
  });
  this.unseenCount = ko.observable(0);
  this.allowChangeTitle = ko.observable(false); // allows to change favicon and browser title when browser is inactive
  this.inactiveTitle = ko.observable('');
  this.excludedHashes = ko.observableArray([]);
}
CHeaderItemView.prototype.ViewTemplate = 'CoreWebclient_HeaderItemView';
CHeaderItemView.prototype.setName = function (sName) {
  this.sName = sName.toLowerCase();
  if (this.baseHash() === '') {
    this.hash(Routing.buildHashFromArray([sName.toLowerCase()]));
    this.baseHash(this.hash());
  } else {
    this.hash(this.baseHash());
  }
};
module.exports = CHeaderItemView;

/***/ }),

/***/ "gSOl":
/*!****************************************************************!*\
  !*** ./modules/RocketChatWebclient/js/views/HeaderItemView.js ***!
  \****************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var _ = __webpack_require__(/*! underscore */ "C3HO"),
  ko = __webpack_require__(/*! knockout */ "p09A"),
  TextUtils = __webpack_require__(/*! modules/CoreWebclient/js/utils/Text.js */ "LKDt"),
  Types = __webpack_require__(/*! modules/CoreWebclient/js/utils/Types.js */ "ERH9"),
  Ajax = __webpack_require__(/*! modules/RocketChatWebclient/js/Ajax.js */ "TFLG"),
  CAbstractHeaderItemView = __webpack_require__(/*! modules/CoreWebclient/js/views/CHeaderItemView.js */ "cR1d"),
  WindowOpener = __webpack_require__(/*! modules/CoreWebclient/js/WindowOpener.js */ "zVyH");
function CHeaderItemView() {
  CAbstractHeaderItemView.call(this, TextUtils.i18n('ROCKETCHATWEBCLIENT/ACTION_SHOW_CHAT'));
  this.iAutoCheckMailTimer = -1;
  this.unseenCount = ko.observable(0);
  this.mainHref = ko.computed(function () {
    return this.hash();
  }, this);
}
CHeaderItemView.prototype.onChatClick = function (data, event) {
  WindowOpener.open('?chat', 'Chat');
};
_.extendOwn(CHeaderItemView.prototype, CAbstractHeaderItemView.prototype);
CHeaderItemView.prototype.ViewTemplate = 'RocketChatWebclient_HeaderItemView';
var HeaderItemView = new CHeaderItemView();
HeaderItemView.allowChangeTitle(true);
module.exports = HeaderItemView;

/***/ })

}]);