"use strict";
(self["webpackChunkafterlogic_aurora_platform"] = self["webpackChunkafterlogic_aurora_platform"] || []).push([[34],{

/***/ "2MaX":
/*!***********************************************************************!*\
  !*** ./modules/OfficeDocumentEditor/js/popups/CreateDocumentPopup.js ***!
  \***********************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {



var _ = __webpack_require__(/*! underscore */ "C3HO"),
  ko = __webpack_require__(/*! knockout */ "p09A"),
  CAbstractPopup = __webpack_require__(/*! modules/CoreWebclient/js/popups/CAbstractPopup.js */ "69av");

/**
 * @constructor
 */
function CCreateDocumentPopup() {
  CAbstractPopup.call(this);
  this.fCallback = null;
  this.filename = ko.observable('');
  this.filename.focus = ko.observable(false);
  this.filename.error = ko.observable('');
  this.sExtension = '';
  this.filename.subscribe(function () {
    this.filename.error('');
  }, this);
}
_.extendOwn(CCreateDocumentPopup.prototype, CAbstractPopup.prototype);
CCreateDocumentPopup.prototype.PopupTemplate = 'OfficeDocumentEditor_CreateDocumentPopup';

/**
 * @param {Function} fCallback
 */
CCreateDocumentPopup.prototype.onOpen = function (sBlankName, sExtension, fCallback) {
  this.filename(sBlankName);
  this.filename.focus(true);
  this.filename.error('');
  this.sExtension = sExtension;
  this.fCallback = fCallback;
};
CCreateDocumentPopup.prototype.create = function () {
  this.filename.error('');
  if (_.isFunction(this.fCallback)) {
    var sError = this.fCallback(this.filename(), this.sExtension);
    if (sError) {
      this.filename.error('' + sError);
    } else {
      this.closePopup();
    }
  } else {
    this.closePopup();
  }
};
module.exports = new CCreateDocumentPopup();

/***/ }),

/***/ "4nRx":
/*!*********************************************************************!*\
  !*** ./modules/OfficeDocumentEditor/js/views/CAddFileButtonView.js ***!
  \*********************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

/* provided dependency */ var $ = __webpack_require__(/*! jquery */ "M4cL");


var ko = __webpack_require__(/*! knockout */ "p09A"),
  Utils = __webpack_require__(/*! modules/CoreWebclient/js/utils/Common.js */ "uQaC"),
  TextUtils = __webpack_require__(/*! modules/CoreWebclient/js/utils/Text.js */ "LKDt"),
  Ajax = __webpack_require__(/*! modules/CoreWebclient/js/Ajax.js */ "8QQh"),
  Api = __webpack_require__(/*! modules/CoreWebclient/js/Api.js */ "Z9uT"),
  ModulesManager = __webpack_require__(/*! modules/CoreWebclient/js/ModulesManager.js */ "5D2l"),
  Popups = __webpack_require__(/*! modules/CoreWebclient/js/Popups.js */ "PMEU"),
  CFileModel = ModulesManager.run('FilesWebclient', 'getFileConstructor'),
  CreateDocumentPopup = __webpack_require__(/*! modules/OfficeDocumentEditor/js/popups/CreateDocumentPopup.js */ "2MaX");

/**
 * @constructor
 */
function CAddFileButtonView(koStorageType, koCurrentPath) {
  this.storageType = ko.isObservable(koStorageType) ? koStorageType : ko.observable('');
  this.currentPath = ko.isObservable(koCurrentPath) ? koCurrentPath : ko.observable('');
  this.allowCreateItems = ko.computed(function () {
    return this.storageType() !== Enums.FileStorageType.Encrypted && this.storageType() !== Enums.FileStorageType.Shared;
  }, this);
  this.createDocumentCommand = Utils.createCommand(this, this.createDocument, this.allowCreateItems);
  this.createSpreadSheetCommand = Utils.createCommand(this, this.createSpreadSheet, this.allowCreateItems);
  this.createPresentationCommand = Utils.createCommand(this, this.createPresentation, this.allowCreateItems);
}
CAddFileButtonView.prototype.ViewTemplate = 'OfficeDocumentEditor_AddFileButtonView';
CAddFileButtonView.prototype.createDocument = function () {
  Popups.showPopup(CreateDocumentPopup, [TextUtils.i18n('OFFICEDOCUMENTEDITOR/LABEL_BLANK_DOCUMENT_NAME'), 'docx', this.createDocumentWithName.bind(this)]);
};
CAddFileButtonView.prototype.createDocumentWithName = function (sBlankName, sExtension) {
  sBlankName = $.trim(sBlankName);
  if (!Utils.validateFileOrFolderName(sBlankName)) {
    return TextUtils.i18n('FILESWEBCLIENT/ERROR_INVALID_FILE_NAME');
  } else {
    Ajax.send('OfficeDocumentEditor', 'CreateBlankDocument', {
      'Type': this.storageType(),
      'Path': this.currentPath(),
      'FileName': sBlankName + '.' + sExtension
    }, this.onCreateBlankDocumentResponse, this);
  }
  return '';
};
CAddFileButtonView.prototype.onCreateBlankDocumentResponse = function (oResponse) {
  if (oResponse && oResponse.Result) {
    var oFile = new CFileModel(oResponse.Result);
    if (oFile.path() === this.currentPath() && oFile.storageType() === this.storageType()) {
      ModulesManager.run('FilesWebclient', 'addFileToCurrentFolder', [oFile]);
    }
    ModulesManager.run('FilesWebclient', 'refresh');
    oFile.executeAction('edit');
  } else {
    Api.showErrorByCode(oResponse);
  }
};
CAddFileButtonView.prototype.createSpreadSheet = function () {
  Popups.showPopup(CreateDocumentPopup, [TextUtils.i18n('OFFICEDOCUMENTEDITOR/LABEL_BLANK_SPREADSHEET_NAME'), 'xlsx', this.createDocumentWithName.bind(this)]);
};
CAddFileButtonView.prototype.createPresentation = function () {
  Popups.showPopup(CreateDocumentPopup, [TextUtils.i18n('OFFICEDOCUMENTEDITOR/LABEL_BLANK_PRESENTATION_NAME'), 'pptx', this.createDocumentWithName.bind(this)]);
};
module.exports = CAddFileButtonView;

/***/ }),

/***/ "G0wi":
/*!***************************************************************!*\
  !*** ./modules/OfficeDocumentEditor/js/utils/FilesActions.js ***!
  \***************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {



var _ = __webpack_require__(/*! underscore */ "C3HO"),
  moment = __webpack_require__(/*! moment */ "sdEb"),
  Types = __webpack_require__(/*! modules/CoreWebclient/js/utils/Types.js */ "ERH9"),
  UrlUtils = __webpack_require__(/*! modules/CoreWebclient/js/utils/Url.js */ "3cxN"),
  Ajax = __webpack_require__(/*! modules/CoreWebclient/js/Ajax.js */ "8QQh"),
  Api = __webpack_require__(/*! modules/CoreWebclient/js/Api.js */ "Z9uT"),
  ModulesManager = __webpack_require__(/*! modules/CoreWebclient/js/ModulesManager.js */ "5D2l"),
  Popups = __webpack_require__(/*! modules/CoreWebclient/js/Popups.js */ "PMEU"),
  WindowOpener = __webpack_require__(/*! modules/CoreWebclient/js/WindowOpener.js */ "zVyH"),
  CFileModel = ModulesManager.run('FilesWebclient', 'getFileConstructor'),
  ConvertPopup = __webpack_require__(/*! modules/OfficeDocumentEditor/js/popups/ConvertPopup.js */ "nMjd"),
  oOpenedWindows = {},
  oSyncStartedMoments = {},
  iCheckWindowsInterval = 0,
  FilesActions = {};
function checkOpenedWindows() {
  _.each(oOpenedWindows, function (oData, sFullPath) {
    var oWin = oData['Win'];
    if (oWin.closed) {
      oSyncStartedMoments[sFullPath] = moment();
      delete oOpenedWindows[sFullPath];
    }
  });
  if (_.isEmpty(oOpenedWindows)) {
    clearInterval(iCheckWindowsInterval);
  }
}
function addOpenedWindow(oFile, oWin) {
  var sFullPath = oFile.fullPath();
  oOpenedWindows[sFullPath] = {
    'Win': oWin,
    'File': oFile
  };
  clearInterval(iCheckWindowsInterval);
  iCheckWindowsInterval = setInterval(function () {
    checkOpenedWindows();
  }, 500);
}
FilesActions.view = function () {
  var oWin = null,
    sUrl = UrlUtils.getAppPath() + this.getActionUrl('view') + '/' + moment().unix();
  if (Types.isNonEmptyString(sUrl) && sUrl !== '#') {
    oWin = WindowOpener.open(sUrl, sUrl, false);
    if (oWin) {
      oWin.focus();
    }
  }
};
FilesActions.edit = function () {
  if (oOpenedWindows[this.fullPath()] && !oOpenedWindows[this.fullPath()].Win.closed) {
    oOpenedWindows[this.fullPath()].Win.focus();
  } else {
    var oWin = null,
      sUrl = this.getActionUrl('edit');
    if (Types.isNonEmptyString(sUrl) && sUrl !== '#') {
      if (sUrl === 'convert') {} else {
        sUrl = UrlUtils.getAppPath() + sUrl + '/' + moment().unix();
        oWin = WindowOpener.open(sUrl, sUrl, false);
        if (oWin) {
          addOpenedWindow(this, oWin);
          oWin.focus();
        }
      }
    }
  }
};
function convertFile(fClosePopup, koConvertInProgress) {
  Ajax.send('OfficeDocumentEditor', 'ConvertDocument', {
    'Type': this.storageType(),
    'Path': this.path(),
    'FileName': this.fileName()
  }, function (oResponse) {
    if (_.isFunction(koConvertInProgress)) {
      koConvertInProgress(false);
    }
    if (oResponse && oResponse.Result) {
      var oFile = new CFileModel(oResponse.Result);
      ModulesManager.run('FilesWebclient', 'refresh');
      oFile.executeAction('edit');
      if (_.isFunction(fClosePopup)) {
        fClosePopup();
      }
    } else {
      Api.showErrorByCode(oResponse);
    }
  }, this);
}
;
FilesActions.convert = function () {
  Popups.showPopup(ConvertPopup, [convertFile.bind(this), FilesActions.view.bind(this)]);
};
module.exports = FilesActions;

/***/ }),

/***/ "HGC9":
/*!****************************************************!*\
  !*** ./modules/OfficeDocumentEditor/js/manager.js ***!
  \****************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {



module.exports = function (oAppData) {
  var _ = __webpack_require__(/*! underscore */ "C3HO"),
    $ = __webpack_require__(/*! jquery */ "M4cL"),
    ko = __webpack_require__(/*! knockout */ "p09A"),
    TextUtils = __webpack_require__(/*! modules/CoreWebclient/js/utils/Text.js */ "LKDt"),
    Types = __webpack_require__(/*! modules/CoreWebclient/js/utils/Types.js */ "ERH9"),
    App = __webpack_require__(/*! modules/CoreWebclient/js/App.js */ "yU9o"),
    CAbstractFileModel = __webpack_require__(/*! modules/CoreWebclient/js/models/CAbstractFileModel.js */ "LIBG"),
    CAddFileButtonView = __webpack_require__(/*! modules/OfficeDocumentEditor/js/views/CAddFileButtonView.js */ "4nRx"),
    FilesActions = __webpack_require__(/*! modules/OfficeDocumentEditor/js/utils/FilesActions.js */ "G0wi"),
    FilesSettings = __webpack_require__(/*! modules/FilesWebclient/js/Settings.js */ "aSuo");
  var addFileButtonView = ko.observable(null);
  var executeCommand = function executeCommand(view, sCommandName) {
    var oView = view();
    if (oView) {
      if (oView[sCommandName]) {
        var command = oView[sCommandName];
        if (command.canExecute()) {
          command();
        }
      }
    } else if (ko.isObservable(addFileButtonView)) {
      var subscription = addFileButtonView.subscribe(function (oView) {
        if (oView && oView[sCommandName]) {
          var _command = oView[sCommandName];
          if (_command.canExecute()) {
            _command();
          }
        }
        subscription.dispose();
      });
    }
  };
  if (App.isUserNormalOrTenant()) {
    return {
      start: function start(ModulesManager) {
        var aExtensionsToView = oAppData['OfficeDocumentEditor'] ? oAppData['OfficeDocumentEditor']['ExtensionsToView'] : [];
        aExtensionsToView = aExtensionsToView.map(function (item) {
          return Types.pString(item).toLowerCase();
        });
        CAbstractFileModel.addViewExtensions(aExtensionsToView);
        App.subscribeEvent('FilesWebclient::ConstructView::after', function (oParams) {
          if (oParams.Name === 'CFilesView') {
            var oView = oParams.View;
            if (oView && _.isFunction(oView.registerCreateButtonsController)) {
              addFileButtonView(new CAddFileButtonView(oView.storageType, oView.currentPath));
              oView.registerCreateButtonsController(addFileButtonView());
            }
          }
        });
        App.subscribeEvent('FilesWebclient::ParseFile::after', function (aParams) {
          var oFile = aParams[0],
            oRawData = aParams[1],
            sFileExtension = Types.pString(oFile.extension()).toLowerCase();
          if (oFile.hasAction('view') && oFile.oActionsData['view'] && -1 !== $.inArray(sFileExtension, aExtensionsToView)) {
            delete oFile.oActionsData['view'].HandlerName;
            oFile.oActionsData['view'].Handler = FilesActions.view.bind(oFile);
          }
          if (oFile.hasAction('convert')) {
            oFile.removeAction('convert');
            if (oFile.oActionsData['convert']) {
              oFile.actions.unshift('convert');
              oFile.oActionsData['convert'].Text = TextUtils.i18n('OFFICEDOCUMENTEDITOR/ACTION_EDIT_FILE');
              oFile.oActionsData['convert'].Handler = FilesActions.convert.bind(oFile);
            }
            if (oFile.hasAction('view')) {
              oFile.removeAction('view');
              oFile.actions.push('view');
            }
          }
          if (oFile.hasAction('edit')) {
            oFile.removeAction('edit');
            if (oFile.oActionsData['edit']) {
              oFile.actions.unshift('edit');
              oFile.oActionsData['edit'].Text = TextUtils.i18n('OFFICEDOCUMENTEDITOR/ACTION_EDIT_FILE');
              oFile.oActionsData['edit'].Handler = FilesActions.edit.bind(oFile);
            }
            if (oFile.hasAction('view')) {
              oFile.removeAction('view');
              oFile.actions.push('view');
            }
          }
        });
        App.broadcastEvent('RegisterNewItemElement', {
          'title': TextUtils.i18n('OFFICEDOCUMENTEDITOR/ACTION_CREATE_DOCUMENT'),
          'handler': function handler() {
            // check if we are on Files screen or not
            if (!window.location.hash.startsWith('#' + FilesSettings.HashModuleName)) {
              window.location.hash = FilesSettings.HashModuleName;
            }
            executeCommand(addFileButtonView, 'createDocumentCommand');
          },
          'className': 'item_document',
          'order': 5,
          'column': 2
        });
        App.broadcastEvent('RegisterNewItemElement', {
          'title': TextUtils.i18n('OFFICEDOCUMENTEDITOR/ACTION_CREATE_SPREADSHEET'),
          'handler': function handler() {
            // check if we are on Files screen or not
            if (!window.location.hash.startsWith('#' + FilesSettings.HashModuleName)) {
              window.location.hash = FilesSettings.HashModuleName;
            }
            executeCommand(addFileButtonView, 'createSpreadSheetCommand');
          },
          'className': 'item_spreadsheet',
          'order': 5,
          'column': 2
        });
        App.broadcastEvent('RegisterNewItemElement', {
          'title': TextUtils.i18n('OFFICEDOCUMENTEDITOR/ACTION_CREATE_PRESENTATION'),
          'handler': function handler() {
            // check if we are on Files screen or not
            if (!window.location.hash.startsWith('#' + FilesSettings.HashModuleName)) {
              window.location.hash = FilesSettings.HashModuleName;
            }
            executeCommand(addFileButtonView, 'createPresentationCommand');
          },
          'className': 'item_presentation',
          'order': 5,
          'column': 2
        });
      }
    };
  }
  return null;
};

/***/ }),

/***/ "aSuo":
/*!***********************************************!*\
  !*** ./modules/FilesWebclient/js/Settings.js ***!
  \***********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {



var _ = __webpack_require__(/*! underscore */ "C3HO"),
  Types = __webpack_require__(/*! modules/CoreWebclient/js/utils/Types.js */ "ERH9");
module.exports = {
  ServerModuleName: 'Files',
  CorporateServerModuleName: 'CorporateFiles',
  PersonalServerModuleName: 'PersonalFiles',
  HashModuleName: 'files',
  Storages: [],
  EnableUploadSizeLimit: false,
  PublicFolderName: '',
  PublicHash: '',
  UploadSizeLimitMb: 0,
  UserSpaceLimitMb: 0,
  TenantSpaceLimitMb: 0,
  CorporateSpaceLimitMb: 0,
  AllowTrash: false,
  AllowFavorites: false,
  EditFileNameWithoutExtension: false,
  ShowCommonSettings: true,
  ShowFilesApps: true,
  BottomLeftCornerLinks: [],
  CustomTabTitle: '',
  ShowPersonalFilesAdminSection: false,
  ShowCorporateFilesAdminSection: false,
  PublicLinksEnabled: true,
  Sorting: {
    Allow: false
  },
  /**
   * Initializes settings from AppData object sections.
   *
   * @param {Object} oAppData Object contained modules settings.
   */
  init: function init(oAppData) {
    var oAppDataFilesSection = oAppData[this.ServerModuleName],
      // oAppDataPersonalFilesSection = oAppData[this.PersonalServerModuleName],
      oAppDataCorporateFilesSection = oAppData[this.CorporateServerModuleName],
      oAppDataFilesWebclientSection = oAppData['FilesWebclient'];
    if (!_.isEmpty(oAppDataFilesSection)) {
      this.Storages = Types.pArray(oAppDataFilesSection.Storages, this.Storages);
      this.EnableUploadSizeLimit = Types.pBool(oAppDataFilesSection.EnableUploadSizeLimit, this.EnableUploadSizeLimit);
      this.PublicFolderName = Types.pString(oAppDataFilesSection.PublicFolderName, this.PublicFolderName);
      this.PublicHash = Types.pString(oAppDataFilesSection.PublicHash, this.PublicHash);
      this.UploadSizeLimitMb = Types.pNonNegativeInt(oAppDataFilesSection.UploadSizeLimitMb, this.UploadSizeLimitMb);
      this.UserSpaceLimitMb = Types.pNonNegativeInt(oAppDataFilesSection.UserSpaceLimitMb, this.UserSpaceLimitMb);
      this.TenantSpaceLimitMb = Types.pNonNegativeInt(oAppDataFilesSection.TenantSpaceLimitMb, this.TenantSpaceLimitMb);
      this.AllowTrash = Types.pBool(oAppDataFilesSection.AllowTrash, this.AllowTrash);
      this.AllowFavorites = Types.pBool(oAppDataFilesSection.AllowFavorites, this.AllowFavorites);
      // this.EFilesSortField = Types.pObject(oAppDataFilesSection.SortField);
    }

    // if (!_.isEmpty(oAppDataPersonalFilesSection))
    // {
    this.ShowPersonalFilesAdminSection = true;
    // }

    if (!_.isEmpty(oAppDataCorporateFilesSection)) {
      this.ShowCorporateFilesAdminSection = true;
      this.CorporateSpaceLimitMb = Types.pNonNegativeInt(oAppDataCorporateFilesSection.SpaceLimitMb, this.CorporateSpaceLimitMb);
    }
    if (!_.isEmpty(oAppDataFilesWebclientSection)) {
      this.EditFileNameWithoutExtension = Types.pBool(oAppDataFilesWebclientSection.EditFileNameWithoutExtension, this.EditFileNameWithoutExtension);
      this.ShowCommonSettings = Types.pBool(oAppDataFilesWebclientSection.ShowCommonSettings, this.ShowCommonSettings);
      this.ShowFilesApps = Types.pBool(oAppDataFilesWebclientSection.ShowFilesApps, this.ShowFilesApps);
      this.BottomLeftCornerLinks = Types.pArray(oAppDataFilesWebclientSection.BottomLeftCornerLinks, this.BottomLeftCornerLinks);
      this.PublicLinksEnabled = Types.pBool(oAppDataFilesWebclientSection.PublicLinksEnabled, this.PublicLinksEnabled);
      this.Sorting = this.getSortConfig(Types.pObject(oAppDataFilesWebclientSection.FilesSortBy));
      this.CustomTabTitle = Types.pString(oAppDataFilesWebclientSection.CustomTabTitle, this.CustomTabTitle);
    }
  },
  /**
   * Updates settings from settings tab in admin panel.
   *
   * @param {boolean} bEnableUploadSizeLimit Indicates if upload size limit is enabled.
   * @param {number} iUploadSizeLimitMb Value of upload size limit in Mb.
   */
  updateAdmin: function updateAdmin(bEnableUploadSizeLimit, iUploadSizeLimitMb) {
    this.EnableUploadSizeLimit = bEnableUploadSizeLimit;
    this.UploadSizeLimitMb = iUploadSizeLimitMb;
  },
  updateAdminPersonal: function updateAdminPersonal(iUserSpaceLimitMb) {
    this.PersonalSpaceLimitMb = iUserSpaceLimitMb;
  },
  updateAdminCorporate: function updateAdminCorporate(iSpaceLimitMb) {
    this.CorporateSpaceLimitMb = iSpaceLimitMb;
  },
  getSortConfig: function getSortConfig(config) {
    return {
      Allow: Types.pBool(config === null || config === void 0 ? void 0 : config.Allow),
      DisplayOptions: (config === null || config === void 0 ? void 0 : config.DisplayOptions) || [],
      DefaultSortBy: Types.pEnum(Enums.FilesSortField[config === null || config === void 0 ? void 0 : config.DefaultSortBy], Enums.FilesSortField, Enums.FilesSortField.Filename),
      DefaultSortOrder: Types.pEnum(Enums.SortOrder[config === null || config === void 0 ? void 0 : config.DefaultSortOrder], Enums.SortOrder, Enums.SortOrder.Desc)
    };
  }
};

/***/ }),

/***/ "nMjd":
/*!****************************************************************!*\
  !*** ./modules/OfficeDocumentEditor/js/popups/ConvertPopup.js ***!
  \****************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {



var _ = __webpack_require__(/*! underscore */ "C3HO"),
  ko = __webpack_require__(/*! knockout */ "p09A"),
  CAbstractPopup = __webpack_require__(/*! modules/CoreWebclient/js/popups/CAbstractPopup.js */ "69av");

/**
 * @constructor
 */
function CConvertPopup() {
  CAbstractPopup.call(this);
  this.convertInProgress = ko.observable(false);
  this.fConvertCallback = null;
  this.fViewCallback = null;
}
_.extendOwn(CConvertPopup.prototype, CAbstractPopup.prototype);
CConvertPopup.prototype.PopupTemplate = 'OfficeDocumentEditor_ConvertPopup';

/**
 * @param {Function} fConvertCallback
 * @param {Function} fViewCallback
 */
CConvertPopup.prototype.onOpen = function (fConvertCallback, fViewCallback) {
  this.convertInProgress(false);
  this.fConvertCallback = fConvertCallback;
  this.fViewCallback = fViewCallback;
};
CConvertPopup.prototype.convert = function () {
  if (_.isFunction(this.fConvertCallback)) {
    this.convertInProgress(true);
    this.fConvertCallback(this.closePopup.bind(this), this.convertInProgress);
  }
};
CConvertPopup.prototype.view = function () {
  if (_.isFunction(this.fViewCallback)) {
    this.fViewCallback();
  }
  this.closePopup();
};
CConvertPopup.prototype.cancelPopup = function () {
  this.closePopup();
};
module.exports = new CConvertPopup();

/***/ })

}]);