"use strict";
(self["webpackChunkafterlogic_aurora_platform"] = self["webpackChunkafterlogic_aurora_platform"] || []).push([[27],{

/***/ "K+2K":
/*!*************************************************!*\
  !*** ./modules/MailSignup/js/views/MainView.js ***!
  \*************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {



var _ = __webpack_require__(/*! underscore */ "C3HO"),
  $ = __webpack_require__(/*! jquery */ "M4cL"),
  ko = __webpack_require__(/*! knockout */ "p09A"),
  TextUtils = __webpack_require__(/*! modules/CoreWebclient/js/utils/Text.js */ "LKDt"),
  UrlUtils = __webpack_require__(/*! modules/CoreWebclient/js/utils/Url.js */ "3cxN"),
  Utils = __webpack_require__(/*! modules/CoreWebclient/js/utils/Common.js */ "uQaC"),
  Ajax = __webpack_require__(/*! modules/CoreWebclient/js/Ajax.js */ "8QQh"),
  Api = __webpack_require__(/*! modules/CoreWebclient/js/Api.js */ "Z9uT"),
  App = __webpack_require__(/*! modules/CoreWebclient/js/App.js */ "yU9o"),
  Browser = __webpack_require__(/*! modules/CoreWebclient/js/Browser.js */ "/Odb"),
  CAbstractScreenView = __webpack_require__(/*! modules/CoreWebclient/js/views/CAbstractScreenView.js */ "db2p"),
  Screens = __webpack_require__(/*! modules/CoreWebclient/js/Screens.js */ "D2Gh"),
  Settings = __webpack_require__(/*! modules/MailSignup/js/Settings.js */ "TkEq"),
  $html = $('html');

/**
 * @constructor
 */
function CMainView() {
  CAbstractScreenView.call(this, 'MailSignup');
  this.sCustomLogoUrl = Settings.CustomLogoUrl;
  this.sInfoText = Settings.InfoText;
  this.sBottomInfoHtmlText = Settings.BottomInfoHtmlText;
  this.aDomainList = ko.observableArray(Settings.DomainList);
  this.sSelectedDomain = ko.observable('');
  this.name = ko.observable('');
  this.enableNameEdit = ko.observable(true);
  this.login = ko.observable('');
  this.enableLoginEdit = ko.observable(true);
  this.password = ko.observable('');
  this.confirmPassword = ko.observable('');
  this.nameFocus = ko.observable(false);
  this.loginFocus = ko.observable(false);
  this.passwordFocus = ko.observable(false);
  this.confirmPasswordFocus = ko.observable(false);
  this.loading = ko.observable(false);
  this.canTrySignup = ko.computed(function () {
    return !this.loading();
  }, this);
  this.signupButtonText = ko.computed(function () {
    return this.loading() ? TextUtils.i18n('MAILSIGNUP/ACTION_SIGNUP_IN_PROGRESS') : TextUtils.i18n('MAILSIGNUP/ACTION_SIGNUP');
  }, this);
  this.signupCommand = Utils.createCommand(this, this.signup, this.canTrySignup);
  this.shake = ko.observable(false).extend({
    'autoResetToFalse': 800
  });
  this.beforeButtonsControllers = ko.observableArray([]);
  App.broadcastEvent('AnonymousUserForm::PopulateBeforeButtonsControllers', {
    ModuleName: 'MailSignup',
    RegisterBeforeButtonsController: this.registerBeforeButtonsController.bind(this)
  });
  this.welcomeText = ko.observable('');
  App.subscribeEvent('ShowWelcomeSignupText', _.bind(function (oParams) {
    this.welcomeText(oParams.WelcomeText);
    this.login(oParams.UserName);
    this.enableLoginEdit(false);
  }, this));
  App.broadcastEvent('MailSignup::ConstructView::after', {
    'Name': this.ViewConstructorName,
    'View': this
  });
}
_.extendOwn(CMainView.prototype, CAbstractScreenView.prototype);
CMainView.prototype.ViewTemplate = 'MailSignup_MainView';
CMainView.prototype.ViewConstructorName = 'CMainView';
CMainView.prototype.onBind = function () {
  $html.addClass('non-adjustable-valign');
};

/**
 * Focuses login input after view showing.
 */
CMainView.prototype.onShow = function () {
  _.delay(_.bind(function () {
    if (this.login() === '') {
      this.loginFocus(true);
    }
  }, this), 1);
};

/**
 * @param {string} sLogin
 * @param {string} sPassword
 * @param {string} sConfirmPassword
 * @returns {Boolean}
 */
CMainView.prototype.validateForm = function (sLogin, sPassword, sConfirmPassword) {
  if (sLogin === '') {
    this.loginFocus(true);
    this.shake(true);
    return false;
  }
  if (sPassword === '') {
    this.passwordFocus(true);
    this.shake(true);
    return false;
  }
  if (sPassword !== '' && sPassword !== sConfirmPassword) {
    this.confirmPasswordFocus(true);
    this.shake(true);
    Screens.showError(TextUtils.i18n('COREWEBCLIENT/ERROR_PASSWORDS_DO_NOT_MATCH'));
    return false;
  }
  return true;
};

/**
 * Checks login input value and sends signup request to server.
 */
CMainView.prototype.signup = function () {
  if (!this.loading()) {
    var sName = $.trim(this.name()),
      sLogin = $.trim(this.login()) + '@' + this.sSelectedDomain(),
      sPassword = $.trim(this.password()),
      sConfirmPassword = $.trim(this.confirmPassword()),
      oParameters = {
        'Name': sName,
        'Login': sLogin,
        'Password': sPassword
      };
    App.broadcastEvent('AnonymousUserForm::PopulateFormSubmitParameters', {
      Module: 'MailSignup',
      Parameters: oParameters
    });
    if (this.validateForm(sLogin, sPassword, sConfirmPassword)) {
      this.loading(true);
      Ajax.send('MailSignup', 'Signup', oParameters, this.onSignupResponse, this);
    }
  }
};

/**
 * Receives data from the server. Shows error and shakes form if server has returned false-result.
 * Otherwise clears search-string if it don't contain "reset-pass", "invite-auth" and "oauth" parameters and reloads page.
 * 
 * @param {Object} oResponse Data obtained from the server.
 * @param {Object} oRequest Data has been transferred to the server.
 */
CMainView.prototype.onSignupResponse = function (oResponse, oRequest) {
  if (false === oResponse.Result) {
    this.loading(false);
    this.shake(true);
    Api.showErrorByCode(oResponse, TextUtils.i18n('MAILSIGNUP/ERROR_SIGNUP_FAILED'));
  } else {
    if (window.location.search !== '' && UrlUtils.getRequestParam('reset-pass') === null && UrlUtils.getRequestParam('invite-auth') === null && UrlUtils.getRequestParam('oauth') === null) {
      UrlUtils.clearAndReloadLocation(Browser.ie8AndBelow, true);
    } else {
      UrlUtils.clearAndReloadLocation(Browser.ie8AndBelow, false);
    }
  }
};

/**
 * @param {Object} oComponent
 */
CMainView.prototype.registerBeforeButtonsController = function (oComponent) {
  this.beforeButtonsControllers.push(oComponent);
};
module.exports = new CMainView();

/***/ }),

/***/ "SRBC":
/*!******************************************!*\
  !*** ./modules/MailSignup/js/manager.js ***!
  \******************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {



module.exports = function (oAppData) {
  var App = __webpack_require__(/*! modules/CoreWebclient/js/App.js */ "yU9o"),
    Settings = __webpack_require__(/*! modules/MailSignup/js/Settings.js */ "TkEq"),
    bAnonimUser = App.getUserRole() === Enums.UserRole.Anonymous;
  Settings.init(oAppData);
  if (!App.isPublic() && bAnonimUser) {
    if (App.isMobile()) {
      return {
        /**
         * Returns signup view screen as is.
         */
        getSignupScreenView: function getSignupScreenView() {
          return __webpack_require__(/*! modules/MailSignup/js/views/MainView.js */ "K+2K");
        },
        getHashModuleName: function getHashModuleName() {
          return Settings.HashModuleName;
        }
      };
    } else {
      return {
        /**
         * Returns signup view screen.
         */
        getScreens: function getScreens() {
          var oScreens = {};
          oScreens[Settings.HashModuleName] = function () {
            return __webpack_require__(/*! modules/MailSignup/js/views/MainView.js */ "K+2K");
          };
          return oScreens;
        }
      };
    }
  }
  return null;
};

/***/ }),

/***/ "TkEq":
/*!*******************************************!*\
  !*** ./modules/MailSignup/js/Settings.js ***!
  \*******************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {



var _ = __webpack_require__(/*! underscore */ "C3HO"),
  Types = __webpack_require__(/*! modules/CoreWebclient/js/utils/Types.js */ "ERH9");
module.exports = {
  ServerModuleName: 'MailSignup',
  HashModuleName: 'signup',
  CustomLogoUrl: '',
  InfoText: '',
  BottomInfoHtmlText: '',
  DomainList: [],
  /**
   * Initializes settings from AppData object sections.
   * 
   * @param {Object} oAppData Object contained modules settings.
   */
  init: function init(oAppData) {
    var oAppDataSection = oAppData['MailSignup'];
    if (!_.isEmpty(oAppDataSection)) {
      var aDomainList = Types.pArray(oAppDataSection.DomainList, this.DomainList);
      this.ServerModuleName = Types.pString(oAppDataSection.ServerModuleName, this.ServerModuleName);
      this.HashModuleName = Types.pString(oAppDataSection.HashModuleName, this.HashModuleName);
      this.CustomLogoUrl = Types.pString(oAppDataSection.CustomLogoUrl, this.CustomLogoUrl);
      this.InfoText = Types.pString(oAppDataSection.InfoText, this.InfoText);
      this.BottomInfoHtmlText = Types.pString(oAppDataSection.BottomInfoHtmlText, this.BottomInfoHtmlText);
      this.DomainList = Types.isNonEmptyArray(aDomainList) ? aDomainList : ['no domain set'];
    }
  }
};

/***/ })

}]);