<?php
/**
 * This code is licensed under AGPLv3 license or Afterlogic Software License
 * if commercial version of the product was purchased.
 * For full statements of the licenses see LICENSE-AFTERLOGIC and LICENSE-AGPL3 files.
 */

namespace Aurora\Modules\SessionTimeoutWebclient;

use Aurora\System\SettingsProperty;

/**
 * @property bool $Disabled
 * @property int $TimeoutMinutes
 * @property bool $IncludeInMobile
 */

class Settings extends \Aurora\System\Module\Settings
{
    protected function initDefaults()
    {
        $this->aContainer = [
            "Disabled" => new SettingsProperty(
                false,
                "bool",
                null,
                "Setting to true disables the module",
            ),
            "TimeoutMinutes" => new SettingsProperty(
                30,
                "int",
                null,
                "Time interval of inactivity the users are logged after",
            ),
            "IncludeInMobile" => new SettingsProperty(
                true,
                "bool",
                null,
                "If true, the module is used in mobile version of the interface",
            ),
        ];
    }
}
