(window["webpackJsonp"] = window["webpackJsonp"] || []).push([[48],{

/***/ "JyQu":
/*!****************************************************!*\
  !*** ./modules/OfficeDocumentEditor/js/manager.js ***!
  \****************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


module.exports = function (oAppData) {
	var
		_ = __webpack_require__(/*! underscore */ "xG9w"),
		$ = __webpack_require__(/*! jquery */ "EVdn"),

		TextUtils = __webpack_require__(/*! modules/CoreWebclient/js/utils/Text.js */ "RN+F"),

		App = __webpack_require__(/*! modules/CoreWebclient/js/App.js */ "IAk5"),

		CAbstractFileModel = __webpack_require__(/*! modules/CoreWebclient/js/models/CAbstractFileModel.js */ "cGGv"),

		FilesActions = __webpack_require__(/*! modules/OfficeDocumentEditor/js/utils/FilesActions.js */ "q+Ee")
	;

	if (App.isUserNormalOrTenant())
	{
		return {
			start: function (ModulesManager) {
				var aExtensionsToView = oAppData['OfficeDocumentEditor'] ? oAppData['OfficeDocumentEditor']['ExtensionsToView'] : [];
				CAbstractFileModel.addViewExtensions(aExtensionsToView);
				App.subscribeEvent('FilesWebclient::ConstructView::after', function (oParams) {
					if (oParams.Name === 'CFilesView') {
						var oView = oParams.View;
						if (oView && _.isFunction(oView.registerCreateButtonsController))
						{
							var CAddFileButtonView = __webpack_require__(/*! modules/OfficeDocumentEditor/js/views/CAddFileButtonView.js */ "wMN5");
							oView.registerCreateButtonsController(new CAddFileButtonView(oView.storageType, oView.currentPath));
						}
					}
				});
				App.subscribeEvent('FilesWebclient::ParseFile::after', function (aParams) {
					var
						oFile = aParams[0],
						oRawData = aParams[1]
					;

					if (oFile.hasAction('view') && oFile.oActionsData['view'] && -1 !== $.inArray(oFile.extension(), aExtensionsToView))
					{
						delete oFile.oActionsData['view'].HandlerName;
						oFile.oActionsData['view'].Handler = FilesActions.view.bind(oFile);
					}
					if (oFile.hasAction('convert')) {
						oFile.removeAction('convert');
						if (oFile.oActionsData['convert']) {
							oFile.actions.unshift('convert');
							oFile.oActionsData['convert'].Text = TextUtils.i18n('OFFICEDOCUMENTEDITOR/ACTION_EDIT_FILE');
							oFile.oActionsData['convert'].Handler = FilesActions.convert.bind(oFile);
						}
						if (oFile.hasAction('view'))
						{
							oFile.removeAction('view');
							oFile.actions.push('view');
						}
					}
					if (oFile.hasAction('edit'))
					{
						oFile.removeAction('edit');
						if (oFile.oActionsData['edit'])
						{
							oFile.actions.unshift('edit');
							oFile.oActionsData['edit'].Text = TextUtils.i18n('OFFICEDOCUMENTEDITOR/ACTION_EDIT_FILE');
							oFile.oActionsData['edit'].Handler = FilesActions.edit.bind(oFile);
						}
						if (oFile.hasAction('view'))
						{
							oFile.removeAction('view');
							oFile.actions.push('view');
						}
					}
				});
			}
		};
	}

	return null;
};


/***/ }),

/***/ "N++n":
/*!****************************************************************!*\
  !*** ./modules/OfficeDocumentEditor/js/popups/ConvertPopup.js ***!
  \****************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var
	_ = __webpack_require__(/*! underscore */ "xG9w"),
	ko = __webpack_require__(/*! knockout */ "0h2I"),

	CAbstractPopup = __webpack_require__(/*! modules/CoreWebclient/js/popups/CAbstractPopup.js */ "czxF")
;

/**
 * @constructor
 */
function CConvertPopup()
{
	CAbstractPopup.call(this);

	this.convertInProgress = ko.observable(false);

	this.fConvertCallback = null;
	this.fViewCallback = null;
}

_.extendOwn(CConvertPopup.prototype, CAbstractPopup.prototype);

CConvertPopup.prototype.PopupTemplate = 'OfficeDocumentEditor_ConvertPopup';

/**
 * @param {Function} fConvertCallback
 * @param {Function} fViewCallback
 */
CConvertPopup.prototype.onOpen = function (fConvertCallback, fViewCallback)
{
	this.convertInProgress(false);

	this.fConvertCallback = fConvertCallback;
	this.fViewCallback = fViewCallback;
};

CConvertPopup.prototype.convert = function ()
{
	if (_.isFunction(this.fConvertCallback))
	{
		this.convertInProgress(true);
		this.fConvertCallback(this.closePopup.bind(this), this.convertInProgress);
	}
};

CConvertPopup.prototype.view = function ()
{
	if (_.isFunction(this.fViewCallback))
	{
		this.fViewCallback();
	}

	this.closePopup();
};

CConvertPopup.prototype.cancelPopup = function ()
{
	this.closePopup();
};

module.exports = new CConvertPopup();


/***/ }),

/***/ "QFUI":
/*!*************************************************!*\
  !*** ./modules/CoreWebclient/js/utils/Files.js ***!
  \*************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var
	TextUtils = __webpack_require__(/*! modules/CoreWebclient/js/utils/Text.js */ "RN+F"),
	
	Popups = __webpack_require__(/*! modules/CoreWebclient/js/Popups.js */ "76Kh"),
	AlertPopup = __webpack_require__(/*! modules/CoreWebclient/js/popups/AlertPopup.js */ "1grR"),
	
	UserSettings = __webpack_require__(/*! modules/CoreWebclient/js/Settings.js */ "hPb3"),
	
	FilesUtils = {}
;

/**
 * Gets link for download by hash.
 *
 * @param {string} sModuleName Name of module that owns the file.
 * @param {string} sHash Hash of the file.
 * @param {string} sPublicHash Hash of shared folder if the file is displayed by public link.
 * 
 * @return {string}
 */
FilesUtils.getDownloadLink = function (sModuleName, sHash, sPublicHash)
{
	return sHash.length > 0 ? '?/Download/' + sModuleName + '/DownloadFile/' + sHash + '/' + (sPublicHash ? '0/' + sPublicHash : '') : '';
};

/**
 * Gets link for view by hash in iframe.
 *
 * @param {number} iAccountId
 * @param {string} sUrl
 *
 * @return {string}
 */
FilesUtils.getIframeWrappwer = function (iAccountId, sUrl)
{
	return '?/Raw/Iframe/' + iAccountId + '/' + window.encodeURIComponent(sUrl) + '/';
};

FilesUtils.thumbQueue = (function () {

	var
		oImages = {},
		oImagesIncrements = {},
		iNumberOfImages = 2
	;

	return function (sImageSrc, fImageSrcObserver)
	{
		if(fImageSrcObserver)
		{
			if(!(sImageSrc in oImagesIncrements) || oImagesIncrements[sImageSrc] > 0) //load first images
			{
				if(!(sImageSrc in oImagesIncrements)) //on first image
				{
					oImagesIncrements[sImageSrc] = iNumberOfImages;
					oImages[sImageSrc] = [];
				}
				oImagesIncrements[sImageSrc]--;

				fImageSrcObserver(sImageSrc); //load image
			}
			else //create queue
			{
				oImages[sImageSrc].push({
					imageSrc: sImageSrc,
					imageSrcObserver: fImageSrcObserver
				});
			}
		}
		else //load images from queue (fires load event)
		{
			if(oImages[sImageSrc] && oImages[sImageSrc].length)
			{
				oImages[sImageSrc][0].imageSrcObserver(oImages[sImageSrc][0].imageSrc);
				oImages[sImageSrc].shift();
			}
		}
	};
}());

/**
 * @param {string} sFileName
 * @param {number} iSize
 * @returns {Boolean}
 */
FilesUtils.showErrorIfAttachmentSizeLimit = function (sFileName, iSize)
{
	var
		sWarning = TextUtils.i18n('COREWEBCLIENT/ERROR_UPLOAD_SIZE_DETAILED', {
			'FILENAME': sFileName,
			'MAXSIZE': TextUtils.getFriendlySize(UserSettings.AttachmentSizeLimit)
		})
	;
	
	if (UserSettings.AttachmentSizeLimit > 0 && iSize > UserSettings.AttachmentSizeLimit)
	{
		Popups.showPopup(AlertPopup, [sWarning]);
		return true;
	}
	
	return false;
};

module.exports = FilesUtils;


/***/ }),

/***/ "cGGv":
/*!***************************************************************!*\
  !*** ./modules/CoreWebclient/js/models/CAbstractFileModel.js ***!
  \***************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var
	_ = __webpack_require__(/*! underscore */ "xG9w"),
	$ = __webpack_require__(/*! jquery */ "EVdn"),
	ko = __webpack_require__(/*! knockout */ "0h2I"),
	moment = __webpack_require__(/*! moment */ "wd/R"),

	App = __webpack_require__(/*! modules/CoreWebclient/js/App.js */ "IAk5"),
	FilesUtils = __webpack_require__(/*! modules/CoreWebclient/js/utils/Files.js */ "QFUI"),
	TextUtils = __webpack_require__(/*! modules/CoreWebclient/js/utils/Text.js */ "RN+F"),
	Types = __webpack_require__(/*! modules/CoreWebclient/js/utils/Types.js */ "AFLV"),
	UrlUtils = __webpack_require__(/*! modules/CoreWebclient/js/utils/Url.js */ "ZP6a"),
	Utils = __webpack_require__(/*! modules/CoreWebclient/js/utils/Common.js */ "Yjhd"),

	WindowOpener = __webpack_require__(/*! modules/CoreWebclient/js/WindowOpener.js */ "ZCBP"),

	aViewMimeTypes = [
		'image/jpeg', 'image/jpg', 'image/png', 'image/gif',
		'text/html', 'text/plain', 'text/css',
		'text/rfc822-headers', 'message/delivery-status',
		'application/x-httpd-php', 'application/javascript'
	],

	aViewExtensions = []
;

if ($('html').hasClass('pdf'))
{
	aViewMimeTypes.push('application/pdf');
	aViewMimeTypes.push('application/x-pdf');
}

/**
 * @constructor
 */
function CAbstractFileModel()
{
	this.id = ko.observable('');
	this.index = ko.observable(0);
	this.fileName = ko.observable('');
	this.tempName = ko.observable('');
	this.extension = ko.observable('');

	this.fileName.subscribe(function (sFileName) {
		this.id(sFileName);
		this.extension(Utils.getFileExtension(sFileName));
	}, this);

	// Can be overwritten
	this.displayName = ko.computed(function () {
		return this.fileName();
	}, this);

	this.size = ko.observable(0);
	this.friendlySize = ko.computed(function () {
		return this.size() > 0 ? TextUtils.getFriendlySize(this.size()) : '';
	}, this);

	this.hash = ko.observable('');

	this.thumbUrlInQueue = ko.observable('');
	this.thumbUrlInQueueSubscribtion = this.thumbUrlInQueue.subscribe(function () {
		this.getInThumbQueue();
	}, this);

	this.thumbnailSrc = ko.observable('');
	this.thumbnailLoaded = ko.observable(false);

	this.mimeType = ko.observable('');
	this.uploadUid = ko.observable('');
	this.uploaded = ko.observable(false);
	this.uploadError = ko.observable(false);
	this.downloading = ko.observable(false);
	this.isViewMimeType = ko.computed(function () {
		return (-1 !== $.inArray(this.mimeType(), aViewMimeTypes));
	}, this);
	this.bHasHtmlEmbed = false;

	this.otherTemplates = ko.observableArray([]);

	// Some modules can override this field if it is necessary to manage it.
	this.visibleCancelButton = ko.observable(true);
	this.cancelButtonTooltip = TextUtils.i18n('COREWEBCLIENT/ACTION_CANCEL');

	this.statusText = ko.observable('');
	this.statusTooltip = ko.computed(function () {
		return this.uploadError() ? this.statusText() : '';
	}, this);
	this.progressPercent = ko.observable(0);
	this.visibleProgress = ko.observable(false);

	this.uploadStarted = ko.observable(false);
	this.uploadStarted.subscribe(function () {
		if (this.uploadStarted())
		{
			this.uploaded(false);
			this.visibleProgress(true);
			this.progressPercent(20);
		}
		else
		{
			this.progressPercent(100);
			this.visibleProgress(false);
			this.uploaded(true);
		}
	}, this);

	this.downloading.subscribe(function () {
		if (this.downloading())
		{
			this.visibleProgress(true);
		}
		else
		{
			this.visibleProgress(false);
			this.progressPercent(0);
		}
	}, this);

	this.allowDrag = ko.observable(false);
	this.allowUpload = ko.observable(false);
	this.allowPublicLink = ko.observable(false);
	this.bIsSecure = ko.observable(false);

	this.sHeaderText = '';

	this.oActionsData = {
		'view': {
			'Text': TextUtils.i18n('COREWEBCLIENT/ACTION_VIEW_FILE'),
			'HandlerName': 'viewFile'
		},
		'download': {
			'Text': TextUtils.i18n('COREWEBCLIENT/ACTION_DOWNLOAD_FILE'),
			'HandlerName': 'downloadFile',
			'Tooltip': ko.computed(function () {
				var sTitle = TextUtils.i18n('COREWEBCLIENT/INFO_CLICK_TO_DOWNLOAD_FILE', {
					'FILENAME': this.fileName(),
					'SIZE': this.friendlySize()
				});

				if (this.friendlySize() === '')
				{
					sTitle = sTitle.replace(' ()', '');
				}

				return sTitle;
			}, this)
		}
	};

	this.allowActions = ko.observable(true);

	this.iconAction = ko.observable('download');

	this.cssClasses = ko.computed(function () {
		return this.getCommonClasses().join(' ');
	}, this);

	this.actions = ko.observableArray([]);

	this.firstAction = ko.computed(function () {
		if (this.actions().length > 1)
		{
			return this.actions()[0];
		}
		return '';
	}, this);

	this.secondAction = ko.computed(function () {
		if (this.actions().length === 1)
		{
			return this.actions()[0];
		}
		if (this.actions().length > 1)
		{
			return this.actions()[1];
		}
		return '';
	}, this);

	this.subFiles = ko.observableArray([]);
	this.subFilesExpanded = ko.observable(false);

	this.sUploadSubFolder = '';
	this.bIsHidden = false;
}

CAbstractFileModel.prototype.addAction = function (sAction, bMain, oActionData)
{
	if (bMain)
	{
		this.actions.unshift(sAction);
	}
	else
	{
		this.actions.push(sAction);
	}
	this.actions(_.compact(this.actions()));
	if (oActionData)
	{
		this.oActionsData[sAction] = oActionData;
	}
};

CAbstractFileModel.prototype.removeAction = function (sAction)
{
	this.actions(_.without(this.actions(), sAction));
};

CAbstractFileModel.prototype.getMainAction = function ()
{
	return this.actions()[0];
};

CAbstractFileModel.prototype.hasAction = function (sAction)
{
	return _.indexOf(this.actions(), sAction) !== -1;
};

/**
 * Returns button text for specified action.
 * @param {string} sAction
 * @returns string
 */
CAbstractFileModel.prototype.getActionText = function (sAction)
{
	if (this.hasAction(sAction) && this.oActionsData[sAction] && (typeof this.oActionsData[sAction].Text === 'string' || _.isFunction(this.oActionsData[sAction].Text)))
	{
		return _.isFunction(this.oActionsData[sAction].Text) ? this.oActionsData[sAction].Text() : this.oActionsData[sAction].Text;
	}
	return '';
};

CAbstractFileModel.prototype.getActionUrl = function (sAction)
{
	return (this.hasAction(sAction) && this.oActionsData[sAction]) ? (this.oActionsData[sAction].Url || '') : '';
};

/**
 * Executes specified action.
 * @param {string} sAction
 */
CAbstractFileModel.prototype.executeAction = function (sAction)
{
	var oData = this.hasAction(sAction) && this.oActionsData[sAction];
	if (oData)
	{
		if (_.isFunction(oData.Handler)) {
			oData.Handler();
		}
		else if (typeof oData.HandlerName === 'string' && _.isFunction(this[oData.HandlerName]))
		{
			this[oData.HandlerName]();
		}
	}
};

/**
 * Returns tooltip for specified action.
 * @param {string} sAction
 * @returns string
 */
CAbstractFileModel.prototype.getTooltip = function (sAction)
{
	var mTootip = this.hasAction(sAction) && this.oActionsData[sAction] ? this.oActionsData[sAction].Tooltip : '';
	if (typeof mTootip === 'string')
	{
		return mTootip;
	}
	if (_.isFunction(mTootip))
	{
		return mTootip();
	}
	return '';
};

/**
 * Returns list of css classes for file.
 * @returns array
 */
CAbstractFileModel.prototype.getCommonClasses = function ()
{
	var aClasses = [];

	if ((this.allowUpload() && !this.uploaded()) || this.downloading())
	{
		aClasses.push('incomplete');
	}
	if (this.uploadError())
	{
		aClasses.push('fail');
	}
	else
	{
		aClasses.push('success');
	}

	return aClasses;
};

/**
 * Parses attachment data from server.
 * @param {AjaxAttachmenResponse} oData
 */
CAbstractFileModel.prototype.parse = function (oData)
{
	this.fileName(Types.pString(oData.FileName));
	this.tempName(Types.pString(oData.TempName));
	if (this.tempName() === '')
	{
		this.tempName(this.fileName());
	}

	this.mimeType(Types.pString(oData.MimeType));
	this.size(oData.EstimatedSize ? Types.pInt(oData.EstimatedSize) : Types.pInt(oData.SizeInBytes));

	this.hash(Types.pString(oData.Hash));

	this.parseActions(oData);

	this.uploadUid(this.hash());
	this.uploaded(true);

	if ($.isFunction(this.additionalParse))
	{
		this.additionalParse(oData);
	}
};

CAbstractFileModel.prototype.parseActions = function (oData)
{
	this.thumbUrlInQueue(Types.pString(oData.ThumbnailUrl) !== '' ? Types.pString(oData.ThumbnailUrl) + '/' + Math.random() : '');
	this.commonParseActions(oData);
	this.commonExcludeActions();
};

CAbstractFileModel.prototype.commonExcludeActions = function ()
{
	if (!this.isViewSupported())
	{
		this.actions(_.without(this.actions(), 'view'));
	}
};

CAbstractFileModel.prototype.commonParseActions = function (oData)
{
	_.each (oData.Actions, function (oData, sAction) {
		if (!this.oActionsData[sAction])
		{
			this.oActionsData[sAction] = {};
		}
		this.oActionsData[sAction].Url = Types.pString(oData.url);
		this.actions.push(sAction);
	}, this);
};

CAbstractFileModel.addViewExtensions = function (aAddViewExtensions)
{
	if (_.isArray(aAddViewExtensions))
	{
		aViewExtensions = _.union(aViewExtensions, aAddViewExtensions);
	}
};

CAbstractFileModel.prototype.isViewSupported = function ()
{
	return (-1 !== $.inArray(this.mimeType(), aViewMimeTypes) || -1 !== $.inArray(this.extension(), aViewExtensions));
};

CAbstractFileModel.prototype.getInThumbQueue = function ()
{
	if(this.thumbUrlInQueue() !== '' && (!this.linked || this.linked && !this.linked()))
	{
		FilesUtils.thumbQueue(this.thumbUrlInQueue(), this.thumbnailSrc);
	}
};

/**
 * Starts downloading attachment on click.
 */
CAbstractFileModel.prototype.downloadFile = function (bNotBroadcastEvent)
{
	//todo: UrlUtils.downloadByUrl in nessesary context in new window
	var
		sDownloadLink = this.getActionUrl('download'),
		oParams = {
			'File': this,
			'CancelDownload': false
		}
	;
	if (sDownloadLink.length > 0 && sDownloadLink !== '#')
	{
		if (!bNotBroadcastEvent)
		{
			App.broadcastEvent('AbstractFileModel::FileDownload::before', oParams);
		}
		if (!oParams.CancelDownload)
		{
			if (_.isFunction(oParams.CustomDownloadHandler))
			{
				oParams.CustomDownloadHandler();
			}
			else
			{
				sDownloadLink += '/' + moment().unix();
				UrlUtils.downloadByUrl(sDownloadLink, this.extension() === 'eml');
			}
		}
	}
};

/**
 * Can be overridden.
 * Starts viewing attachment on click.
 * @param {Object} oViewModel
 * @param {Object} oEvent
 */
CAbstractFileModel.prototype.viewFile = function (oViewModel, oEvent)
{
	Utils.calmEvent(oEvent);
	this.viewCommonFile();
};

/**
 * Starts viewing attachment on click.
 * @param {string=} sUrl
 */
CAbstractFileModel.prototype.viewCommonFile = function (sUrl)
{
	var
		oWin = null,
		oParams = null
	;

	if (!Types.isNonEmptyString(sUrl))
	{
		sUrl = UrlUtils.getAppPath() + this.getActionUrl('view');
	}

	if (sUrl.length > 0 && sUrl !== '#')
	{
		sUrl += '/' + moment().unix();
		oParams = {
			sUrl,
			index: this.index(),
			hash: this.hash(),
			continueView: true
		};

		App.broadcastEvent('AbstractFileModel::FileView::before', oParams);

		if (oParams.continueView) {
			oWin = WindowOpener.open(oParams.sUrl, oParams.sUrl, false);

			if (oWin)
			{
				oWin.focus();
			}
		}
	}
};

/**
 * This allows to download a file from the Webmail UI using drag-n-drop
 * @param {Object} oAttachment
 * @param {*} oEvent
 * @return {boolean}
 */
CAbstractFileModel.prototype.eventDragStart = function (oAttachment, oEvent)
{
	var oLocalEvent = oEvent.originalEvent || oEvent;
	if (oAttachment && oLocalEvent && oLocalEvent.dataTransfer && oLocalEvent.dataTransfer.setData)
	{
		oLocalEvent.dataTransfer.setData('DownloadURL', this.generateTransferDownloadUrl());
	}

	return true;
};

/**
 * @return {string}
 */
CAbstractFileModel.prototype.generateTransferDownloadUrl = function ()
{
	var sLink = this.getActionUrl('download');
	if ('http' !== sLink.substr(0, 4))
	{
		sLink = UrlUtils.getAppPath() + sLink;
	}

	return this.mimeType() + ':' + this.fileName() + ':' + sLink;
};

/**
 * Fills attachment data for upload.
 *
 * @param {string} sFileUid
 * @param {Object} oFileData
 * @param {bool} bOnlyUploadStatus
 */
CAbstractFileModel.prototype.onUploadSelect = function (sFileUid, oFileData, bOnlyUploadStatus)
{
	if (!bOnlyUploadStatus)
	{
		this.fileName(Types.pString(oFileData['FileName']));
		this.mimeType(Types.pString(oFileData['Type']));
		this.size(Types.pInt(oFileData['Size']));
	}

	this.uploadUid(sFileUid);
	this.uploaded(false);
	this.statusText('');
	this.progressPercent(0);
	this.visibleProgress(false);

	// if uploading file is from uploading folder it should be hidden in files list.
	this.sUploadSubFolder = Types.pString(oFileData.Folder);
	this.bIsHidden = this.sUploadSubFolder !== '';
};

/**
 * Starts progress.
 */
CAbstractFileModel.prototype.onUploadStart = function ()
{
	this.visibleProgress(true);
};

/**
 * Fills progress upload data.
 *
 * @param {number} iUploadedSize
 * @param {number} iTotalSize
 */
CAbstractFileModel.prototype.onUploadProgress = function (iUploadedSize, iTotalSize)
{
	if (iTotalSize > 0)
	{
		this.progressPercent(Math.ceil(iUploadedSize / iTotalSize * 100));
		this.visibleProgress(true);
	}
};

/**
 * Fills progress download data.
 *
 * @param {number} iDownloadedSize
 * @param {number} iTotalSize
 */
CAbstractFileModel.prototype.onDownloadProgress = function (iDownloadedSize, iTotalSize)
{
	if (iTotalSize > 0)
	{
		this.progressPercent(Math.ceil(iDownloadedSize / iTotalSize * 100));
		this.visibleProgress(this.progressPercent() < 100);
	}
};

/**
 * Fills data when upload has completed.
 *
 * @param {string} sFileUid
 * @param {boolean} bResponseReceived
 * @param {Object} oResponse
 */
CAbstractFileModel.prototype.onUploadComplete = function (sFileUid, bResponseReceived, oResponse)
{
	var
		bError = !bResponseReceived || !oResponse || !!oResponse.ErrorCode || !oResponse.Result || !!oResponse.Result.Error || false,
		sError = (oResponse && oResponse.ErrorCode && oResponse.ErrorCode === Enums.Errors.CanNotUploadFileLimit) ?
			TextUtils.i18n('COREWEBCLIENT/ERROR_UPLOAD_SIZE') :
			TextUtils.i18n('COREWEBCLIENT/ERROR_UPLOAD_UNKNOWN')
	;

	this.progressPercent(0);
	this.visibleProgress(false);

	this.uploaded(true);
	this.uploadError(bError);
	this.statusText(bError ? sError : TextUtils.i18n('COREWEBCLIENT/REPORT_UPLOAD_COMPLETE'));

	if (!bError)
	{
		this.fillDataAfterUploadComplete(oResponse, sFileUid);

		setTimeout((function (self) {
			return function () {
				self.statusText('');
			};
		})(this), 3000);
	}
};

/**
 * Should be overriden.
 *
 * @param {Object} oResult
 * @param {string} sFileUid
 */
CAbstractFileModel.prototype.fillDataAfterUploadComplete = function (oResult, sFileUid)
{
};

/**
 * @param {Object} oAttachmentModel
 * @param {Object} oEvent
 */
CAbstractFileModel.prototype.onImageLoad = function (oAttachmentModel, oEvent)
{
	if(this.thumbUrlInQueue() !== '' && !this.thumbnailLoaded())
	{
		this.thumbnailLoaded(true);
		FilesUtils.thumbQueue(this.thumbUrlInQueue());
	}
};

/**
 * Signalise that file download was stoped.
 */
CAbstractFileModel.prototype.stopDownloading = function ()
{
	this.downloading(false);
};

/**
 * Signalise that file download was started.
 */
CAbstractFileModel.prototype.startDownloading = function ()
{
	this.downloading(true);
};

module.exports = CAbstractFileModel;


/***/ }),

/***/ "gImi":
/*!***********************************************************************!*\
  !*** ./modules/OfficeDocumentEditor/js/popups/CreateDocumentPopup.js ***!
  \***********************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var
	_ = __webpack_require__(/*! underscore */ "xG9w"),
	ko = __webpack_require__(/*! knockout */ "0h2I"),

	CAbstractPopup = __webpack_require__(/*! modules/CoreWebclient/js/popups/CAbstractPopup.js */ "czxF")
;

/**
 * @constructor
 */
function CCreateDocumentPopup()
{
	CAbstractPopup.call(this);
	
	this.fCallback = null;
	this.filename = ko.observable('');
	this.filename.focus = ko.observable(false);
	this.filename.error = ko.observable('');
	this.sExtension = '';

	this.filename.subscribe(function () {
		this.filename.error('');
	}, this);
}

_.extendOwn(CCreateDocumentPopup.prototype, CAbstractPopup.prototype);

CCreateDocumentPopup.prototype.PopupTemplate = 'OfficeDocumentEditor_CreateDocumentPopup';

/**
 * @param {Function} fCallback
 */
CCreateDocumentPopup.prototype.onOpen = function (sBlankName, sExtension, fCallback)
{
	this.filename(sBlankName);
	this.filename.focus(true);
	this.filename.error('');
	this.sExtension = sExtension;
	this.fCallback = fCallback;
};

CCreateDocumentPopup.prototype.create = function ()
{
	this.filename.error('');

	if (_.isFunction(this.fCallback))
	{
		var sError = this.fCallback(this.filename(), this.sExtension);
		if (sError)
		{
			this.filename.error('' + sError);
		}
		else
		{
			this.closePopup();
		}
	}
	else
	{
		this.closePopup();
	}
};

module.exports = new CCreateDocumentPopup();


/***/ }),

/***/ "q+Ee":
/*!***************************************************************!*\
  !*** ./modules/OfficeDocumentEditor/js/utils/FilesActions.js ***!
  \***************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var
	_ = __webpack_require__(/*! underscore */ "xG9w"),
	moment = __webpack_require__(/*! moment */ "wd/R"),

	Types = __webpack_require__(/*! modules/CoreWebclient/js/utils/Types.js */ "AFLV"),
	UrlUtils = __webpack_require__(/*! modules/CoreWebclient/js/utils/Url.js */ "ZP6a"),

	Ajax = __webpack_require__(/*! modules/CoreWebclient/js/Ajax.js */ "o0Bx"),
	Api = __webpack_require__(/*! modules/CoreWebclient/js/Api.js */ "JFZZ"),
	ModulesManager = __webpack_require__(/*! modules/CoreWebclient/js/ModulesManager.js */ "OgeD"),
	Popups = __webpack_require__(/*! modules/CoreWebclient/js/Popups.js */ "76Kh"),
	WindowOpener = __webpack_require__(/*! modules/CoreWebclient/js/WindowOpener.js */ "ZCBP"),

	CFileModel = ModulesManager.run('FilesWebclient', 'getFileConstructor'),

	ConvertPopup = __webpack_require__(/*! modules/OfficeDocumentEditor/js/popups/ConvertPopup.js */ "N++n"),

	oOpenedWindows = {},
	oSyncStartedMoments = {},
	iCheckWindowsInterval = 0,

	FilesActions = {}
;

function checkOpenedWindows()
{
	_.each(oOpenedWindows, function (oData, sFullPath) {
		var oWin = oData['Win'];
		if (oWin.closed)
		{
			oSyncStartedMoments[sFullPath] = moment();
			delete oOpenedWindows[sFullPath];
		}
	});
	if (_.isEmpty(oOpenedWindows))
	{
		clearInterval(iCheckWindowsInterval);
	}
}

function addOpenedWindow(oFile, oWin)
{
	var sFullPath = oFile.fullPath();
	oOpenedWindows[sFullPath] = {
		'Win': oWin,
		'File': oFile
	};
	clearInterval(iCheckWindowsInterval);
	iCheckWindowsInterval = setInterval(function () {
		checkOpenedWindows();
	}, 500);
}

FilesActions.view = function () {
	var
		oWin = null,
		sUrl = UrlUtils.getAppPath() + this.getActionUrl('view') + '/' + moment().unix()
	;
	if (Types.isNonEmptyString(sUrl) && sUrl !== '#')
	{
		oWin = WindowOpener.open(sUrl, sUrl, false);
		if (oWin)
		{
			oWin.focus();
		}
	}
};

FilesActions.edit = function () {
	if (oOpenedWindows[this.fullPath()] && !oOpenedWindows[this.fullPath()].Win.closed) {
		oOpenedWindows[this.fullPath()].Win.focus();
	} else {
		var
			oWin = null,
			sUrl = this.getActionUrl('edit')
		;
		if (Types.isNonEmptyString(sUrl) && sUrl !== '#') {
			if (sUrl === 'convert') {

			} else {
				sUrl = UrlUtils.getAppPath() + sUrl + '/' + moment().unix()
				oWin = WindowOpener.open(sUrl, sUrl, false);
				if (oWin) {
					addOpenedWindow(this, oWin)
					oWin.focus();
				}
			}
		}
	}
};

function convertFile (fClosePopup, koConvertInProgress) {
	Ajax.send('OfficeDocumentEditor', 'ConvertDocument', {
		'Type': this.storageType(),
		'Path': this.path(),
		'FileName': this.fileName()
	}, function (oResponse) {
		if (_.isFunction(koConvertInProgress))
		{
			koConvertInProgress(false);
		}
		if (oResponse && oResponse.Result)
		{
			var oFile = new CFileModel(oResponse.Result);
			ModulesManager.run('FilesWebclient', 'refresh');
			oFile.executeAction('edit');
			if (_.isFunction(fClosePopup))
			{
				fClosePopup();
			}
		}
		else
		{
			Api.showErrorByCode(oResponse);
		}
	}, this);
};

FilesActions.convert = function () {
	Popups.showPopup(ConvertPopup, [convertFile.bind(this), FilesActions.view.bind(this)]);
};

module.exports = FilesActions;


/***/ }),

/***/ "wMN5":
/*!*********************************************************************!*\
  !*** ./modules/OfficeDocumentEditor/js/views/CAddFileButtonView.js ***!
  \*********************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function($) {

var
	_ = __webpack_require__(/*! underscore */ "xG9w"),
	ko = __webpack_require__(/*! knockout */ "0h2I"),

	Utils = __webpack_require__(/*! modules/CoreWebclient/js/utils/Common.js */ "Yjhd"),
	TextUtils = __webpack_require__(/*! modules/CoreWebclient/js/utils/Text.js */ "RN+F"),

	Ajax = __webpack_require__(/*! modules/CoreWebclient/js/Ajax.js */ "o0Bx"),
	Api = __webpack_require__(/*! modules/CoreWebclient/js/Api.js */ "JFZZ"),
	ModulesManager = __webpack_require__(/*! modules/CoreWebclient/js/ModulesManager.js */ "OgeD"),
	Popups = __webpack_require__(/*! modules/CoreWebclient/js/Popups.js */ "76Kh"),

	CFileModel = ModulesManager.run('FilesWebclient', 'getFileConstructor'),

	CreateDocumentPopup = __webpack_require__(/*! modules/OfficeDocumentEditor/js/popups/CreateDocumentPopup.js */ "gImi")
;

/**
 * @constructor
 */
function CAddFileButtonView(koStorageType, koCurrentPath)
{
	this.storageType = _.isFunction(koStorageType) ? koStorageType : ko.observable('');
	this.currentPath = _.isFunction(koCurrentPath) ? koCurrentPath : ko.observable('');

	this.allowCreateItems = ko.computed(function () {
		return	this.storageType() !== Enums.FileStorageType.Encrypted && this.storageType() !== Enums.FileStorageType.Shared;
	}, this);
	this.createDocumentCommand = Utils.createCommand(this, this.createDocument, this.allowCreateItems);
	this.createSpreadSheetCommand = Utils.createCommand(this, this.createSpreadSheet, this.allowCreateItems);
	this.createPresentationCommand = Utils.createCommand(this, this.createPresentation, this.allowCreateItems);
}

CAddFileButtonView.prototype.ViewTemplate = 'OfficeDocumentEditor_AddFileButtonView';

CAddFileButtonView.prototype.createDocument = function ()
{
	Popups.showPopup(CreateDocumentPopup,
		[TextUtils.i18n('OFFICEDOCUMENTEDITOR/LABEL_BLANK_DOCUMENT_NAME'), 'docx', this.createDocumentWithName.bind(this)]);
};

CAddFileButtonView.prototype.createDocumentWithName = function (sBlankName, sExtension)
{
	sBlankName = $.trim(sBlankName);
	if (!Utils.validateFileOrFolderName(sBlankName))
	{
		return TextUtils.i18n('FILESWEBCLIENT/ERROR_INVALID_FILE_NAME');
	}
	else
	{
		Ajax.send('OfficeDocumentEditor', 'CreateBlankDocument', {
			'Type': this.storageType(),
			'Path': this.currentPath(),
			'FileName': sBlankName + '.' + sExtension
		}, this.onCreateBlankDocumentResponse, this);
	}

	return '';
};

CAddFileButtonView.prototype.onCreateBlankDocumentResponse = function (oResponse)
{
	if (oResponse && oResponse.Result)
	{
		var
			oFile = new CFileModel(oResponse.Result)
		;
		if (oFile.path() === this.currentPath() && oFile.storageType() === this.storageType())
		{
			ModulesManager.run('FilesWebclient', 'addFileToCurrentFolder', [oFile]);
		}
		ModulesManager.run('FilesWebclient', 'refresh');
		oFile.executeAction('edit');
	}
	else
	{
		Api.showErrorByCode(oResponse);
	}
};

CAddFileButtonView.prototype.createSpreadSheet = function ()
{
	Popups.showPopup(CreateDocumentPopup,
		[TextUtils.i18n('OFFICEDOCUMENTEDITOR/LABEL_BLANK_SPREADSHEET_NAME'), 'xlsx', this.createDocumentWithName.bind(this)]);
};

CAddFileButtonView.prototype.createPresentation = function ()
{
	Popups.showPopup(CreateDocumentPopup,
		[TextUtils.i18n('OFFICEDOCUMENTEDITOR/LABEL_BLANK_PRESENTATION_NAME'), 'pptx', this.createDocumentWithName.bind(this)]);
};

module.exports = CAddFileButtonView;

/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(/*! jquery */ "EVdn")))

/***/ })

}]);